/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.ClassLoading;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ClassMirror;
import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.PureUtilities.ProgressIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class ClassDiscoveryURLCache {
    private final List<ClassMirror<?>> list;

    public ClassDiscoveryURLCache(URL url) {
        this(url, (ProgressIterator)null);
    }

    public ClassDiscoveryURLCache(URL url, ProgressIterator progress) {
        this.list = new ArrayList();
        ClassDiscovery discovery = new ClassDiscovery();
        discovery.setProgressIterator(progress);
        discovery.setClassDiscoveryCache(null);
        discovery.addDiscoveryLocation(url);
        for (ClassMirror<?> m : discovery.getKnownClasses(url)) {
            ReflectionUtils.set(ClassMirror.class, m, "originalURL", url);
            this.list.add(m);
        }
    }

    public ClassDiscoveryURLCache(URL url, InputStream descriptor) throws IOException, ClassNotFoundException {
        List<ClassMirror<?>> list;
        ObjectInputStream ois = new ObjectInputStream(descriptor);
        try {
            list = (List<ClassMirror<?>>)ois.readObject();
        }
        catch (ClassNotFoundException ex) {
            if (url != null) {
                list = new ClassDiscoveryURLCache((URL)url).list;
            }
            throw ex;
        }
        ois.close();
        for (ClassMirror classMirror : list) {
            ReflectionUtils.set(ClassMirror.class, classMirror, "originalURL", url);
        }
        this.list = list;
    }

    public void writeDescriptor(OutputStream out) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(out);
        oos.writeObject(this.list);
        oos.close();
    }

    public String toString() {
        return "[" + ClassDiscoveryURLCache.class.getSimpleName() + ": " + this.list.size() + "]";
    }

    List<ClassMirror<?>> getClasses() {
        return this.list;
    }

    public List<ClassMirror> getClassList() {
        return new ArrayList<ClassMirror>(this.list);
    }
}

