/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit;

import com.laytonsmith.abstraction.MCWorld;
import com.laytonsmith.abstraction.MCWorldCreator;
import com.laytonsmith.abstraction.bukkit.BukkitMCWorld;
import com.laytonsmith.abstraction.enums.MCWorldEnvironment;
import com.laytonsmith.abstraction.enums.MCWorldType;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCWorldEnvironment;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCWorldType;
import com.laytonsmith.core.Static;
import java.io.File;
import java.util.logging.Level;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;

public class BukkitMCWorldCreator
implements MCWorldCreator {
    WorldCreator creator;

    public BukkitMCWorldCreator(String name) {
        this.creator = new WorldCreator(name);
    }

    @Override
    public MCWorld createWorld() {
        World w = this.creator.createWorld();
        if (w != null && w.getEnvironment() == World.Environment.NORMAL) {
            File end;
            File nether = new File(w.getWorldFolder(), "DIM-1");
            if (nether.exists()) {
                Static.getLogger().log(Level.WARNING, "Loaded " + w.getName() + " world with overworld (NORMAL) environment but found DIM-1 (NETHER) directory exists.");
            }
            if ((end = new File(w.getWorldFolder(), "DIM1")).exists()) {
                Static.getLogger().log(Level.WARNING, "Loaded " + w.getName() + " world with overworld (NORMAL) environment but found DIM1 (THE_END) directory exists.");
            }
        }
        return new BukkitMCWorld(w);
    }

    @Override
    public MCWorldCreator type(MCWorldType type) {
        WorldType wt = (WorldType)BukkitMCWorldType.getConvertor().getConcreteEnum(type);
        this.creator.type(wt);
        return this;
    }

    @Override
    public MCWorldCreator environment(MCWorldEnvironment environment) {
        World.Environment we = (World.Environment)BukkitMCWorldEnvironment.getConvertor().getConcreteEnum(environment);
        this.creator.environment(we);
        return this;
    }

    @Override
    public MCWorldCreator seed(long seed) {
        this.creator.seed(seed);
        return this;
    }

    @Override
    public MCWorldCreator generator(String generator) {
        this.creator.generator(generator);
        return this;
    }

    @Override
    public MCWorldCreator copy(MCWorld toCopy) {
        this.creator.copy((World)toCopy.getHandle());
        return this;
    }
}

