/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.core.AliasCore;
import com.laytonsmith.core.Installer;
import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.MethodScriptCompiler;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Script;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.compiler.analysis.StaticAnalysis;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.StaticRuntimeEnv;
import com.laytonsmith.core.exceptions.CancelCommandException;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.exceptions.ProgramFlowManipulationException;
import com.laytonsmith.core.functions.IncludeCache;
import com.laytonsmith.core.profiler.ProfilePoint;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class LocalPackages {
    private final List<File> autoIncludes = new ArrayList<File>();
    private final List<FileInfo> ms = new ArrayList<FileInfo>();
    private final List<ParseTree> msCompiled = new ArrayList<ParseTree>();
    private final List<FileInfo> msa = new ArrayList<FileInfo>();
    private boolean compileErrors = false;

    boolean hasCompileErrors() {
        return this.compileErrors;
    }

    public List<FileInfo> getMSFiles() {
        return new ArrayList<FileInfo>(this.ms);
    }

    public List<FileInfo> getMSAFiles() {
        return new ArrayList<FileInfo>(this.msa);
    }

    public int getMSFileCount() {
        return this.ms.size();
    }

    public int getMSAFileCount() {
        return this.msa.size();
    }

    public List<File> getAutoIncludes() {
        return this.autoIncludes;
    }

    public void addAutoInclude(File f) {
        this.autoIncludes.add(f);
    }

    public void appendMSA(String s, File path) {
        this.msa.add(new FileInfo(s, path));
    }

    public void appendMS(String s, File path) {
        this.ms.add(new FileInfo(s, path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Script> compileMSA(MCPlayer player2, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs) {
        ArrayList<Script> scripts = new ArrayList<Script>();
        for (FileInfo fi : this.msa) {
            try {
                List<Script> tempScripts;
                ProfilePoint p2 = env.getEnv(StaticRuntimeEnv.class).GetProfiler().start("Compiling " + String.valueOf(fi.file), LogLevel.WARNING);
                try {
                    tempScripts = MethodScriptCompiler.preprocess(MethodScriptCompiler.lex(fi.contents, null, fi.file, false), envs);
                }
                finally {
                    p2.stop();
                }
                for (Script s : tempScripts) {
                    try {
                        try {
                            s.compile(env.clone());
                            s.checkAmbiguous(scripts);
                            scripts.add(s);
                        }
                        catch (ConfigCompileException e) {
                            this.compileErrors = true;
                            ConfigRuntimeException.HandleUncaughtException(e, "Compile error in script. Compilation will attempt to continue, however.", player2);
                        }
                        catch (ConfigCompileGroupException ex) {
                            this.compileErrors = true;
                            for (ConfigCompileException e : ex.getList()) {
                                ConfigRuntimeException.HandleUncaughtException(e, "Compile error in script. Compilation will attempt to continue, however.", player2);
                            }
                        }
                        catch (CloneNotSupportedException e) {
                            throw new Error("Environment wasn't clonable, while it should be.", e);
                        }
                    }
                    catch (RuntimeException ee) {
                        throw new RuntimeException("While processing a script, (" + String.valueOf(fi.file()) + ") an unexpected exception occurred. (No further information is available, unfortunately.)", ee);
                    }
                }
            }
            catch (ConfigCompileException e) {
                this.compileErrors = true;
                ConfigRuntimeException.HandleUncaughtException(e, "Could not compile alias definition in " + String.valueOf(fi.file), player2);
            }
        }
        return scripts;
    }

    public void compileMS(MCPlayer player2, Environment env) {
        HashSet<ConfigCompileException> compileExceptions = new HashSet<ConfigCompileException>();
        if (StaticAnalysis.enabled()) {
            StaticAnalysis.setAndAnalyzeAutoIncludes(this.autoIncludes, env, env.getEnvClasses(), compileExceptions);
        } else {
            for (File f : this.autoIncludes) {
                IncludeCache.get(f, env, env.getEnvClasses(), new StaticAnalysis(true), new Target(0, f, 0), compileExceptions);
            }
        }
        if (!compileExceptions.isEmpty()) {
            this.compileErrors = true;
            for (ConfigCompileException ex : compileExceptions) {
                ConfigRuntimeException.HandleUncaughtException(ex, "Compile error in script.", player2);
            }
        }
        for (FileInfo fi : this.ms) {
            try {
                StaticAnalysis analysis = new StaticAnalysis(true);
                this.msCompiled.add(MethodScriptCompiler.compile(MethodScriptCompiler.lex(fi.contents, env, fi.file, true), env, env.getEnvClasses(), analysis));
            }
            catch (ConfigCompileGroupException e) {
                this.compileErrors = true;
                ConfigRuntimeException.HandleUncaughtException(e, fi.file.getAbsolutePath() + " could not be compiled, due to compile errors.", player2);
            }
            catch (ConfigCompileException e) {
                this.compileErrors = true;
                ConfigRuntimeException.HandleUncaughtException(e, fi.file.getAbsolutePath() + " could not be compiled, due to a compile error.", player2);
            }
            catch (ConfigRuntimeException e) {
                this.compileErrors = true;
                ConfigRuntimeException.HandleUncaughtException(e, env);
            }
        }
    }

    public void executeMS(Environment env) {
        boolean staticAnalysisEnabled = StaticAnalysis.enabled();
        for (ParseTree pt : this.msCompiled) {
            try {
                Environment msFileEnv;
                if (staticAnalysisEnabled) {
                    try {
                        msFileEnv = env.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        throw new Error("Environment wasn't clonable, while it should be.", e);
                    }
                } else {
                    msFileEnv = env;
                }
                MethodScriptCompiler.execute(pt, msFileEnv, null, null);
            }
            catch (ConfigRuntimeException e) {
                ConfigRuntimeException.HandleUncaughtException(e, env);
            }
            catch (CancelCommandException e) {
                if (e.getMessage() == null || e.getMessage().trim().isEmpty()) continue;
                Static.getLogger().log(Level.INFO, e.getMessage());
            }
            catch (ProgramFlowManipulationException e) {
                ConfigRuntimeException.HandleUncaughtException(ConfigRuntimeException.CreateUncatchableException("Cannot break program flow in main files.", e.getTarget()), env);
            }
        }
    }

    public void search(File start) {
        block10: {
            block12: {
                block11: {
                    block9: {
                        if (!start.isDirectory() || start.getName().endsWith(".disabled") || start.getName().endsWith(".library")) break block9;
                        for (File f : start.listFiles()) {
                            this.search(f);
                        }
                        break block10;
                    }
                    if (!start.isFile()) break block10;
                    if (!start.getName().endsWith(".msa")) break block11;
                    try {
                        this.appendMSA(AliasCore.file_get_contents(start.getAbsolutePath()), start);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(AliasCore.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    break block10;
                }
                if (!start.getName().endsWith(".ms")) break block12;
                if (start.getName().equals("auto_include.ms")) {
                    this.addAutoInclude(start);
                } else {
                    try {
                        this.appendMS(AliasCore.file_get_contents(start.getAbsolutePath()), start);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(AliasCore.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                break block10;
            }
            if (!start.getName().endsWith(".mslp")) break block10;
            try {
                this.searchZip(new ZipFile(start));
            }
            catch (IOException ex) {
                Logger.getLogger(AliasCore.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void searchZip(ZipFile file) {
        Enumeration<? extends ZipEntry> entries = file.entries();
        while (entries.hasMoreElements()) {
            ZipEntry ze = entries.nextElement();
            if (ze.getName().endsWith(".ms")) {
                if (ze.getName().equals("auto_include.ms")) {
                    this.addAutoInclude(new File(file.getName() + File.separator + ze.getName()));
                    continue;
                }
                try {
                    this.appendMS(Installer.parseISToString(file.getInputStream(ze)), new File(file.getName() + File.separator + ze.getName()));
                }
                catch (IOException ex) {
                    Logger.getLogger(AliasCore.class.getName()).log(Level.SEVERE, null, ex);
                }
                continue;
            }
            if (!ze.getName().endsWith(".msa")) continue;
            try {
                this.appendMSA(Installer.parseISToString(file.getInputStream(ze)), new File(file.getName() + File.separator + ze.getName()));
            }
            catch (IOException ex) {
                Logger.getLogger(AliasCore.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static final class FileInfo {
        String contents;
        File file;

        private FileInfo(String contents, File file) {
            this.contents = contents;
            this.file = file;
        }

        public String contents() {
            return this.contents;
        }

        public File file() {
            return this.file;
        }
    }
}

