/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.perf4j.servlet;

import com.laytonsmith.libs.org.perf4j.chart.StatisticsChartGenerator;
import com.laytonsmith.libs.org.perf4j.helpers.MiscUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGraphingServlet
extends HttpServlet {
    protected List<String> graphNames;

    public void init() throws ServletException {
        String graphNamesString = this.getInitParameter("graphNames");
        if (graphNamesString != null) {
            this.graphNames = Arrays.asList(MiscUtils.splitAndTrim(graphNamesString, ","));
        }
    }

    public void destroy() {
        this.graphNames = null;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Map<String, StatisticsChartGenerator> chartsByName = this.getChartGeneratorsToDisplay(request);
        response.setContentType("text/html;charset=utf-8");
        this.writeHeader(request, response);
        for (Map.Entry<String, StatisticsChartGenerator> nameAndChart : chartsByName.entrySet()) {
            this.writeChart(nameAndChart.getKey(), nameAndChart.getValue(), request, response);
        }
        this.writeFooter(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void writeHeader(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.getWriter().println("<html>");
        response.getWriter().println("<head>");
        response.getWriter().println("<title>Perf4J Performance Graphs</title>");
        if (request.getParameter("refreshRate") != null) {
            int refreshRate = Integer.parseInt(request.getParameter("refreshRate"));
            response.getWriter().println("<meta http-equiv=\"refresh\" content=\"" + refreshRate + "\">");
        }
        response.getWriter().println("<head>");
        response.getWriter().println("<body>");
    }

    protected void writeChart(String name, StatisticsChartGenerator chartGenerator, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String chartUrl;
        response.getWriter().println("<br><br>");
        String string = chartUrl = chartGenerator == null ? null : chartGenerator.getChartUrl();
        if (chartUrl != null) {
            response.getWriter().println("<b>" + name + "</b><br>");
            response.getWriter().println("<img src=\"" + chartUrl + "\">");
        } else {
            response.getWriter().println("<b>Unknown graph name: " + name + "</b><br>");
        }
    }

    protected void writeFooter(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.getWriter().println("</body>");
        response.getWriter().println("</html>");
        response.getWriter().flush();
    }

    protected Map<String, StatisticsChartGenerator> getChartGeneratorsToDisplay(HttpServletRequest request) {
        List<String> graphsToDisplay = request.getParameter("graphName") != null ? Arrays.asList(request.getParameterValues("graphName")) : (this.graphNames != null ? this.graphNames : this.getAllKnownGraphNames());
        LinkedHashMap<String, StatisticsChartGenerator> retVal = new LinkedHashMap<String, StatisticsChartGenerator>();
        for (String graphName : graphsToDisplay) {
            retVal.put(graphName, this.getGraphByName(graphName));
        }
        return retVal;
    }

    protected abstract StatisticsChartGenerator getGraphByName(String var1);

    protected abstract List<String> getAllKnownGraphNames();
}

