/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.redis.clients.jedis.search.querybuilder;

import com.laytonsmith.libs.redis.clients.jedis.GeoCoordinate;
import com.laytonsmith.libs.redis.clients.jedis.args.GeoUnit;
import com.laytonsmith.libs.redis.clients.jedis.search.querybuilder.DoubleRangeValue;
import com.laytonsmith.libs.redis.clients.jedis.search.querybuilder.GeoValue;
import com.laytonsmith.libs.redis.clients.jedis.search.querybuilder.LongRangeValue;
import com.laytonsmith.libs.redis.clients.jedis.search.querybuilder.RangeValue;
import com.laytonsmith.libs.redis.clients.jedis.search.querybuilder.Value;
import java.util.StringJoiner;

public class Values {
    private Values() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static Value value(final String s) {
        return new ScalableValue(){

            @Override
            public String toString() {
                return s;
            }
        };
    }

    public static GeoValue geo(GeoCoordinate coord, double radius, GeoUnit unit) {
        return new GeoValue(coord.getLongitude(), coord.getLatitude(), radius, unit);
    }

    public static RangeValue between(double from, double to) {
        return new DoubleRangeValue(from, to);
    }

    public static RangeValue between(int from, int to) {
        return new LongRangeValue(from, to);
    }

    public static RangeValue eq(double d) {
        return new DoubleRangeValue(d, d);
    }

    public static RangeValue eq(int i) {
        return new LongRangeValue(i, i);
    }

    public static RangeValue lt(double d) {
        return new DoubleRangeValue(Double.NEGATIVE_INFINITY, d).inclusiveMax(false);
    }

    public static RangeValue lt(int d) {
        return new LongRangeValue(Long.MIN_VALUE, d).inclusiveMax(false);
    }

    public static RangeValue gt(double d) {
        return new DoubleRangeValue(d, Double.POSITIVE_INFINITY).inclusiveMin(false);
    }

    public static RangeValue gt(int d) {
        return new LongRangeValue(d, Long.MAX_VALUE).inclusiveMin(false);
    }

    public static RangeValue le(double d) {
        return Values.lt(d).inclusiveMax(true);
    }

    public static RangeValue le(int d) {
        return Values.lt(d).inclusiveMax(true);
    }

    public static RangeValue ge(double d) {
        return Values.gt(d).inclusiveMin(true);
    }

    public static RangeValue ge(int d) {
        return Values.gt(d).inclusiveMin(true);
    }

    public static Value tags(String ... tags) {
        if (tags.length == 0) {
            throw new IllegalArgumentException("Must have at least one tag");
        }
        final StringJoiner sj = new StringJoiner(" | ");
        for (String s : tags) {
            sj.add(s);
        }
        return new Value(){

            @Override
            public String toString() {
                return "{" + sj.toString() + "}";
            }
        };
    }

    private static abstract class ScalableValue
    extends Value {
        private ScalableValue() {
        }

        @Override
        public boolean isCombinable() {
            return true;
        }
    }
}

