/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.perf4j;

import java.io.Serializable;

public class StopWatch
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 8453041765823416495L;
    public static final String DEFAULT_LOGGER_NAME = "com.laytonsmith.libs.org.perf4j.TimingLogger";
    private static final long NANOS_IN_A_MILLI = 1000000L;
    private long startTime;
    private long nanoStartTime;
    private long elapsedTime;
    private String tag;
    private String message;

    public StopWatch() {
        this("", null);
    }

    public StopWatch(String tag) {
        this(tag, null);
    }

    public StopWatch(String tag, String message) {
        this(System.currentTimeMillis(), -1L, tag, message);
    }

    public StopWatch(long startTime, long elapsedTime, String tag, String message) {
        this.startTime = startTime;
        this.nanoStartTime = elapsedTime == -1L ? System.nanoTime() : -1L;
        this.elapsedTime = elapsedTime;
        this.tag = tag;
        this.message = message;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getElapsedTime() {
        return this.elapsedTime == -1L ? (System.nanoTime() - this.nanoStartTime) / 1000000L : this.elapsedTime;
    }

    public String getTag() {
        return this.tag;
    }

    public StopWatch setTag(String tag) {
        this.tag = tag;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public StopWatch setMessage(String message) {
        this.message = message;
        return this;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
        this.nanoStartTime = System.nanoTime();
        this.elapsedTime = -1L;
    }

    public void start(String tag) {
        this.start();
        this.tag = tag;
    }

    public void start(String tag, String message) {
        this.start();
        this.tag = tag;
        this.message = message;
    }

    public String stop() {
        this.elapsedTime = (System.nanoTime() - this.nanoStartTime) / 1000000L;
        return this.toString();
    }

    public String stop(String tag) {
        this.tag = tag;
        return this.stop();
    }

    public String stop(String tag, String message) {
        this.tag = tag;
        this.message = message;
        return this.stop();
    }

    public String lap(String tag) {
        String retVal = this.stop(tag);
        this.start();
        return retVal;
    }

    public String lap(String tag, String message) {
        String retVal = this.stop(tag, message);
        this.start();
        return retVal;
    }

    public String toString() {
        String message = this.getMessage();
        return "start[" + this.getStartTime() + "] time[" + this.getElapsedTime() + "] tag[" + this.getTag() + (message == null ? "]" : "] message[" + message + "]");
    }

    public StopWatch clone() {
        try {
            return (StopWatch)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new Error("Unexpected CloneNotSupportedException");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StopWatch)) {
            return false;
        }
        StopWatch stopWatch = (StopWatch)o;
        if (this.elapsedTime != stopWatch.elapsedTime) {
            return false;
        }
        if (this.startTime != stopWatch.startTime) {
            return false;
        }
        if (this.nanoStartTime != stopWatch.nanoStartTime) {
            return false;
        }
        if (this.message != null ? !this.message.equals(stopWatch.message) : stopWatch.message != null) {
            return false;
        }
        return !(this.tag != null ? !this.tag.equals(stopWatch.tag) : stopWatch.tag != null);
    }

    public int hashCode() {
        int result = (int)(this.startTime ^ this.startTime >>> 32);
        result = 31 * result + (int)(this.nanoStartTime ^ this.nanoStartTime >>> 32);
        result = 31 * result + (int)(this.elapsedTime ^ this.elapsedTime >>> 32);
        result = 31 * result + (this.tag != null ? this.tag.hashCode() : 0);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        return result;
    }
}

