/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbaero.laterevents;

import com.laytonsmith.PureUtilities.SimpleVersion;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.core.extensions.AbstractExtension;
import com.laytonsmith.core.extensions.MSExtension;
import io.github.jbaero.laterevents.BukkitLaterListener;

@MSExtension(value="LaterEvents")
public class LaterEventsExtension
extends AbstractExtension {
    private LaterListener listener;

    public Version getVersion() {
        return new SimpleVersion(1, 1, 0);
    }

    public void onStartup() {
        if (Implementation.GetServerType() == Implementation.Type.BUKKIT) {
            this.listener = new BukkitLaterListener();
        } else {
            System.out.println("LaterEvents not supported on this implementation yet.");
        }
        if (this.listener != null) {
            this.listener.registerSelf();
        }
    }

    public void onShutdown() {
        if (this.listener != null) {
            this.listener.unregisterSelf();
        }
    }

    public static interface LaterListener {
        public void registerSelf();

        public void unregisterSelf();
    }
}

