/*
 * Decompiled with CFR 0.152.
 */
package com.methodscript.mssms;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.Profiles;
import com.laytonsmith.core.constructs.CSecureString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.StaticRuntimeEnv;
import com.laytonsmith.core.exceptions.CRE.CREIllegalArgumentException;
import com.laytonsmith.core.exceptions.CRE.CREPluginInternalException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.methodscript.mssms.ActionGatewayException;
import com.methodscript.mssms.MSSMS;
import com.methodscript.mssms.twilio.TwilioProfile;
import com.methodscript.mssms.twilio.TwilioSMSActions;

public class MSSMSFunctions {

    @api
    public static class send_sms
    extends AbstractFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREIllegalArgumentException.class, CREPluginInternalException.class};
        }

        public boolean isRestricted() {
            return true;
        }

        public Boolean runAsync() {
            return null;
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            TwilioSMSActions action;
            String id = args[0].val();
            String from = args[1] instanceof CSecureString ? new String(((CSecureString)args[1]).getDecryptedCharArray()) : args[1].val();
            String to = args[2] instanceof CSecureString ? new String(((CSecureString)args[2]).getDecryptedCharArray()) : args[2].val();
            String message = args[3].val();
            Profiles profiles = ((StaticRuntimeEnv)environment.getEnv(StaticRuntimeEnv.class)).getProfiles();
            try {
                Profiles.Profile prof = profiles.getProfileById(id);
                if (!(prof instanceof TwilioProfile)) {
                    throw new CREIllegalArgumentException("Unsupported profile type", t);
                }
                action = new TwilioSMSActions((TwilioProfile)prof);
            }
            catch (Profiles.InvalidProfileException ex) {
                throw new CREIllegalArgumentException(ex.getMessage(), t);
            }
            try {
                action.sendMessage(from, to, message);
            }
            catch (ActionGatewayException ex) {
                throw new CREPluginInternalException(ex.getMessage(), t, (Throwable)ex);
            }
            return CVoid.VOID;
        }

        public String getName() {
            return "send_sms";
        }

        public Integer[] numArgs() {
            return new Integer[]{4};
        }

        public String docs() {
            return "void {id, from, to, message} Sends an SMS from the specified phone number to the specified phone number, with the given message. ---- The profile selected is based on the id, and the phone numbers must be fully qualified, i.e. \"+14556557555\". The phone numbers may be secure_strings.";
        }

        public Version since() {
            return MSSMS.MSSMSVersion.V0_0_1;
        }
    }
}

