/*
 * Decompiled with CFR 0.152.
 */
package com.methodscript.mssms.twilio;

import com.methodscript.mssms.ActionGatewayException;
import com.methodscript.mssms.SMSActions;
import com.methodscript.mssms.twilio.TwilioProfile;
import com.twilio.exception.ApiException;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.api.v2010.account.Message;
import com.twilio.type.PhoneNumber;

public class TwilioSMSActions
implements SMSActions {
    private final TwilioProfile profile;
    private TwilioRestClient client;

    public TwilioSMSActions(TwilioProfile profile) {
        this.profile = profile;
    }

    private void init() {
        if (this.client == null) {
            this.client = new TwilioRestClient.Builder(this.profile.getSid(), this.profile.getAuth()).build();
        }
    }

    @Override
    public void sendMessage(String from, String to, String message) throws ActionGatewayException {
        this.init();
        try {
            Message.creator(new PhoneNumber(to), new PhoneNumber(from), message).create(this.client);
        }
        catch (ApiException ex) {
            throw new ActionGatewayException(ex.getMessage(), ex);
        }
    }
}

