/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.Application;
import java.net.URI;

public class ApplicationCreator
extends Creator<Application> {
    private String pathAccountSid;
    private String apiVersion;
    private URI voiceUrl;
    private HttpMethod voiceMethod;
    private URI voiceFallbackUrl;
    private HttpMethod voiceFallbackMethod;
    private URI statusCallback;
    private HttpMethod statusCallbackMethod;
    private Boolean voiceCallerIdLookup;
    private URI smsUrl;
    private HttpMethod smsMethod;
    private URI smsFallbackUrl;
    private HttpMethod smsFallbackMethod;
    private URI smsStatusCallback;
    private URI messageStatusCallback;
    private String friendlyName;

    public ApplicationCreator() {
    }

    public ApplicationCreator(String pathAccountSid) {
        this.pathAccountSid = pathAccountSid;
    }

    public ApplicationCreator setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public ApplicationCreator setVoiceUrl(URI voiceUrl) {
        this.voiceUrl = voiceUrl;
        return this;
    }

    public ApplicationCreator setVoiceUrl(String voiceUrl) {
        return this.setVoiceUrl(Promoter.uriFromString(voiceUrl));
    }

    public ApplicationCreator setVoiceMethod(HttpMethod voiceMethod) {
        this.voiceMethod = voiceMethod;
        return this;
    }

    public ApplicationCreator setVoiceFallbackUrl(URI voiceFallbackUrl) {
        this.voiceFallbackUrl = voiceFallbackUrl;
        return this;
    }

    public ApplicationCreator setVoiceFallbackUrl(String voiceFallbackUrl) {
        return this.setVoiceFallbackUrl(Promoter.uriFromString(voiceFallbackUrl));
    }

    public ApplicationCreator setVoiceFallbackMethod(HttpMethod voiceFallbackMethod) {
        this.voiceFallbackMethod = voiceFallbackMethod;
        return this;
    }

    public ApplicationCreator setStatusCallback(URI statusCallback) {
        this.statusCallback = statusCallback;
        return this;
    }

    public ApplicationCreator setStatusCallback(String statusCallback) {
        return this.setStatusCallback(Promoter.uriFromString(statusCallback));
    }

    public ApplicationCreator setStatusCallbackMethod(HttpMethod statusCallbackMethod) {
        this.statusCallbackMethod = statusCallbackMethod;
        return this;
    }

    public ApplicationCreator setVoiceCallerIdLookup(Boolean voiceCallerIdLookup) {
        this.voiceCallerIdLookup = voiceCallerIdLookup;
        return this;
    }

    public ApplicationCreator setSmsUrl(URI smsUrl) {
        this.smsUrl = smsUrl;
        return this;
    }

    public ApplicationCreator setSmsUrl(String smsUrl) {
        return this.setSmsUrl(Promoter.uriFromString(smsUrl));
    }

    public ApplicationCreator setSmsMethod(HttpMethod smsMethod) {
        this.smsMethod = smsMethod;
        return this;
    }

    public ApplicationCreator setSmsFallbackUrl(URI smsFallbackUrl) {
        this.smsFallbackUrl = smsFallbackUrl;
        return this;
    }

    public ApplicationCreator setSmsFallbackUrl(String smsFallbackUrl) {
        return this.setSmsFallbackUrl(Promoter.uriFromString(smsFallbackUrl));
    }

    public ApplicationCreator setSmsFallbackMethod(HttpMethod smsFallbackMethod) {
        this.smsFallbackMethod = smsFallbackMethod;
        return this;
    }

    public ApplicationCreator setSmsStatusCallback(URI smsStatusCallback) {
        this.smsStatusCallback = smsStatusCallback;
        return this;
    }

    public ApplicationCreator setSmsStatusCallback(String smsStatusCallback) {
        return this.setSmsStatusCallback(Promoter.uriFromString(smsStatusCallback));
    }

    public ApplicationCreator setMessageStatusCallback(URI messageStatusCallback) {
        this.messageStatusCallback = messageStatusCallback;
        return this;
    }

    public ApplicationCreator setMessageStatusCallback(String messageStatusCallback) {
        return this.setMessageStatusCallback(Promoter.uriFromString(messageStatusCallback));
    }

    public ApplicationCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    @Override
    public Application create(TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathAccountSid + "/Applications.json", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Application creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Application.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.apiVersion != null) {
            request.addPostParam("ApiVersion", this.apiVersion);
        }
        if (this.voiceUrl != null) {
            request.addPostParam("VoiceUrl", this.voiceUrl.toString());
        }
        if (this.voiceMethod != null) {
            request.addPostParam("VoiceMethod", this.voiceMethod.toString());
        }
        if (this.voiceFallbackUrl != null) {
            request.addPostParam("VoiceFallbackUrl", this.voiceFallbackUrl.toString());
        }
        if (this.voiceFallbackMethod != null) {
            request.addPostParam("VoiceFallbackMethod", this.voiceFallbackMethod.toString());
        }
        if (this.statusCallback != null) {
            request.addPostParam("StatusCallback", this.statusCallback.toString());
        }
        if (this.statusCallbackMethod != null) {
            request.addPostParam("StatusCallbackMethod", this.statusCallbackMethod.toString());
        }
        if (this.voiceCallerIdLookup != null) {
            request.addPostParam("VoiceCallerIdLookup", this.voiceCallerIdLookup.toString());
        }
        if (this.smsUrl != null) {
            request.addPostParam("SmsUrl", this.smsUrl.toString());
        }
        if (this.smsMethod != null) {
            request.addPostParam("SmsMethod", this.smsMethod.toString());
        }
        if (this.smsFallbackUrl != null) {
            request.addPostParam("SmsFallbackUrl", this.smsFallbackUrl.toString());
        }
        if (this.smsFallbackMethod != null) {
            request.addPostParam("SmsFallbackMethod", this.smsFallbackMethod.toString());
        }
        if (this.smsStatusCallback != null) {
            request.addPostParam("SmsStatusCallback", this.smsStatusCallback.toString());
        }
        if (this.messageStatusCallback != null) {
            request.addPostParam("MessageStatusCallback", this.messageStatusCallback.toString());
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
    }
}

