/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.QueueCreator;
import com.twilio.rest.api.v2010.account.QueueDeleter;
import com.twilio.rest.api.v2010.account.QueueFetcher;
import com.twilio.rest.api.v2010.account.QueueReader;
import com.twilio.rest.api.v2010.account.QueueUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Queue
extends Resource {
    private static final long serialVersionUID = 115549588553968L;
    private final String accountSid;
    private final Integer averageWaitTime;
    private final Integer currentSize;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String friendlyName;
    private final Integer maxSize;
    private final String sid;
    private final String uri;

    public static QueueFetcher fetcher(String pathAccountSid, String pathSid) {
        return new QueueFetcher(pathAccountSid, pathSid);
    }

    public static QueueFetcher fetcher(String pathSid) {
        return new QueueFetcher(pathSid);
    }

    public static QueueUpdater updater(String pathAccountSid, String pathSid) {
        return new QueueUpdater(pathAccountSid, pathSid);
    }

    public static QueueUpdater updater(String pathSid) {
        return new QueueUpdater(pathSid);
    }

    public static QueueDeleter deleter(String pathAccountSid, String pathSid) {
        return new QueueDeleter(pathAccountSid, pathSid);
    }

    public static QueueDeleter deleter(String pathSid) {
        return new QueueDeleter(pathSid);
    }

    public static QueueReader reader(String pathAccountSid) {
        return new QueueReader(pathAccountSid);
    }

    public static QueueReader reader() {
        return new QueueReader();
    }

    public static QueueCreator creator(String pathAccountSid, String friendlyName) {
        return new QueueCreator(pathAccountSid, friendlyName);
    }

    public static QueueCreator creator(String friendlyName) {
        return new QueueCreator(friendlyName);
    }

    public static Queue fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Queue.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Queue fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Queue.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Queue(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="average_wait_time") Integer averageWaitTime, @JsonProperty(value="current_size") Integer currentSize, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="max_size") Integer maxSize, @JsonProperty(value="sid") String sid, @JsonProperty(value="uri") String uri) {
        this.accountSid = accountSid;
        this.averageWaitTime = averageWaitTime;
        this.currentSize = currentSize;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.maxSize = maxSize;
        this.sid = sid;
        this.uri = uri;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Integer getAverageWaitTime() {
        return this.averageWaitTime;
    }

    public final Integer getCurrentSize() {
        return this.currentSize;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final Integer getMaxSize() {
        return this.maxSize;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Queue other = (Queue)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.averageWaitTime, other.averageWaitTime) && Objects.equals(this.currentSize, other.currentSize) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.maxSize, other.maxSize) && Objects.equals(this.sid, other.sid) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.averageWaitTime, this.currentSize, this.dateCreated, this.dateUpdated, this.friendlyName, this.maxSize, this.sid, this.uri);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("averageWaitTime", this.averageWaitTime).add("currentSize", this.currentSize).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("friendlyName", this.friendlyName).add("maxSize", this.maxSize).add("sid", this.sid).add("uri", this.uri).toString();
    }
}

