/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.conference;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.conference.Participant;
import com.twilio.type.PhoneNumber;
import java.net.URI;
import java.util.List;

public class ParticipantCreator
extends Creator<Participant> {
    private String pathAccountSid;
    private final String pathConferenceSid;
    private final PhoneNumber from;
    private final PhoneNumber to;
    private URI statusCallback;
    private HttpMethod statusCallbackMethod;
    private List<String> statusCallbackEvent;
    private Integer timeout;
    private Boolean record;
    private Boolean muted;
    private String beep;
    private Boolean startConferenceOnEnter;
    private Boolean endConferenceOnExit;
    private URI waitUrl;
    private HttpMethod waitMethod;
    private Boolean earlyMedia;
    private Integer maxParticipants;
    private String conferenceRecord;
    private String conferenceTrim;
    private URI conferenceStatusCallback;
    private HttpMethod conferenceStatusCallbackMethod;
    private List<String> conferenceStatusCallbackEvent;
    private String recordingChannels;
    private URI recordingStatusCallback;
    private HttpMethod recordingStatusCallbackMethod;
    private String sipAuthUsername;
    private String sipAuthPassword;
    private String region;
    private URI conferenceRecordingStatusCallback;
    private HttpMethod conferenceRecordingStatusCallbackMethod;
    private List<String> recordingStatusCallbackEvent;
    private List<String> conferenceRecordingStatusCallbackEvent;
    private Boolean coaching;
    private String callSidToCoach;

    public ParticipantCreator(String pathConferenceSid, PhoneNumber from, PhoneNumber to) {
        this.pathConferenceSid = pathConferenceSid;
        this.from = from;
        this.to = to;
    }

    public ParticipantCreator(String pathAccountSid, String pathConferenceSid, PhoneNumber from, PhoneNumber to) {
        this.pathAccountSid = pathAccountSid;
        this.pathConferenceSid = pathConferenceSid;
        this.from = from;
        this.to = to;
    }

    public ParticipantCreator setStatusCallback(URI statusCallback) {
        this.statusCallback = statusCallback;
        return this;
    }

    public ParticipantCreator setStatusCallback(String statusCallback) {
        return this.setStatusCallback(Promoter.uriFromString(statusCallback));
    }

    public ParticipantCreator setStatusCallbackMethod(HttpMethod statusCallbackMethod) {
        this.statusCallbackMethod = statusCallbackMethod;
        return this;
    }

    public ParticipantCreator setStatusCallbackEvent(List<String> statusCallbackEvent) {
        this.statusCallbackEvent = statusCallbackEvent;
        return this;
    }

    public ParticipantCreator setStatusCallbackEvent(String statusCallbackEvent) {
        return this.setStatusCallbackEvent(Promoter.listOfOne(statusCallbackEvent));
    }

    public ParticipantCreator setTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public ParticipantCreator setRecord(Boolean record) {
        this.record = record;
        return this;
    }

    public ParticipantCreator setMuted(Boolean muted) {
        this.muted = muted;
        return this;
    }

    public ParticipantCreator setBeep(String beep) {
        this.beep = beep;
        return this;
    }

    public ParticipantCreator setStartConferenceOnEnter(Boolean startConferenceOnEnter) {
        this.startConferenceOnEnter = startConferenceOnEnter;
        return this;
    }

    public ParticipantCreator setEndConferenceOnExit(Boolean endConferenceOnExit) {
        this.endConferenceOnExit = endConferenceOnExit;
        return this;
    }

    public ParticipantCreator setWaitUrl(URI waitUrl) {
        this.waitUrl = waitUrl;
        return this;
    }

    public ParticipantCreator setWaitUrl(String waitUrl) {
        return this.setWaitUrl(Promoter.uriFromString(waitUrl));
    }

    public ParticipantCreator setWaitMethod(HttpMethod waitMethod) {
        this.waitMethod = waitMethod;
        return this;
    }

    public ParticipantCreator setEarlyMedia(Boolean earlyMedia) {
        this.earlyMedia = earlyMedia;
        return this;
    }

    public ParticipantCreator setMaxParticipants(Integer maxParticipants) {
        this.maxParticipants = maxParticipants;
        return this;
    }

    public ParticipantCreator setConferenceRecord(String conferenceRecord) {
        this.conferenceRecord = conferenceRecord;
        return this;
    }

    public ParticipantCreator setConferenceTrim(String conferenceTrim) {
        this.conferenceTrim = conferenceTrim;
        return this;
    }

    public ParticipantCreator setConferenceStatusCallback(URI conferenceStatusCallback) {
        this.conferenceStatusCallback = conferenceStatusCallback;
        return this;
    }

    public ParticipantCreator setConferenceStatusCallback(String conferenceStatusCallback) {
        return this.setConferenceStatusCallback(Promoter.uriFromString(conferenceStatusCallback));
    }

    public ParticipantCreator setConferenceStatusCallbackMethod(HttpMethod conferenceStatusCallbackMethod) {
        this.conferenceStatusCallbackMethod = conferenceStatusCallbackMethod;
        return this;
    }

    public ParticipantCreator setConferenceStatusCallbackEvent(List<String> conferenceStatusCallbackEvent) {
        this.conferenceStatusCallbackEvent = conferenceStatusCallbackEvent;
        return this;
    }

    public ParticipantCreator setConferenceStatusCallbackEvent(String conferenceStatusCallbackEvent) {
        return this.setConferenceStatusCallbackEvent(Promoter.listOfOne(conferenceStatusCallbackEvent));
    }

    public ParticipantCreator setRecordingChannels(String recordingChannels) {
        this.recordingChannels = recordingChannels;
        return this;
    }

    public ParticipantCreator setRecordingStatusCallback(URI recordingStatusCallback) {
        this.recordingStatusCallback = recordingStatusCallback;
        return this;
    }

    public ParticipantCreator setRecordingStatusCallback(String recordingStatusCallback) {
        return this.setRecordingStatusCallback(Promoter.uriFromString(recordingStatusCallback));
    }

    public ParticipantCreator setRecordingStatusCallbackMethod(HttpMethod recordingStatusCallbackMethod) {
        this.recordingStatusCallbackMethod = recordingStatusCallbackMethod;
        return this;
    }

    public ParticipantCreator setSipAuthUsername(String sipAuthUsername) {
        this.sipAuthUsername = sipAuthUsername;
        return this;
    }

    public ParticipantCreator setSipAuthPassword(String sipAuthPassword) {
        this.sipAuthPassword = sipAuthPassword;
        return this;
    }

    public ParticipantCreator setRegion(String region) {
        this.region = region;
        return this;
    }

    public ParticipantCreator setConferenceRecordingStatusCallback(URI conferenceRecordingStatusCallback) {
        this.conferenceRecordingStatusCallback = conferenceRecordingStatusCallback;
        return this;
    }

    public ParticipantCreator setConferenceRecordingStatusCallback(String conferenceRecordingStatusCallback) {
        return this.setConferenceRecordingStatusCallback(Promoter.uriFromString(conferenceRecordingStatusCallback));
    }

    public ParticipantCreator setConferenceRecordingStatusCallbackMethod(HttpMethod conferenceRecordingStatusCallbackMethod) {
        this.conferenceRecordingStatusCallbackMethod = conferenceRecordingStatusCallbackMethod;
        return this;
    }

    public ParticipantCreator setRecordingStatusCallbackEvent(List<String> recordingStatusCallbackEvent) {
        this.recordingStatusCallbackEvent = recordingStatusCallbackEvent;
        return this;
    }

    public ParticipantCreator setRecordingStatusCallbackEvent(String recordingStatusCallbackEvent) {
        return this.setRecordingStatusCallbackEvent(Promoter.listOfOne(recordingStatusCallbackEvent));
    }

    public ParticipantCreator setConferenceRecordingStatusCallbackEvent(List<String> conferenceRecordingStatusCallbackEvent) {
        this.conferenceRecordingStatusCallbackEvent = conferenceRecordingStatusCallbackEvent;
        return this;
    }

    public ParticipantCreator setConferenceRecordingStatusCallbackEvent(String conferenceRecordingStatusCallbackEvent) {
        return this.setConferenceRecordingStatusCallbackEvent(Promoter.listOfOne(conferenceRecordingStatusCallbackEvent));
    }

    public ParticipantCreator setCoaching(Boolean coaching) {
        this.coaching = coaching;
        return this;
    }

    public ParticipantCreator setCallSidToCoach(String callSidToCoach) {
        this.callSidToCoach = callSidToCoach;
        return this;
    }

    @Override
    public Participant create(TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathAccountSid + "/Conferences/" + this.pathConferenceSid + "/Participants.json", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Participant creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Participant.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.from != null) {
            request.addPostParam("From", this.from.toString());
        }
        if (this.to != null) {
            request.addPostParam("To", this.to.toString());
        }
        if (this.statusCallback != null) {
            request.addPostParam("StatusCallback", this.statusCallback.toString());
        }
        if (this.statusCallbackMethod != null) {
            request.addPostParam("StatusCallbackMethod", this.statusCallbackMethod.toString());
        }
        if (this.statusCallbackEvent != null) {
            for (String prop : this.statusCallbackEvent) {
                request.addPostParam("StatusCallbackEvent", prop);
            }
        }
        if (this.timeout != null) {
            request.addPostParam("Timeout", this.timeout.toString());
        }
        if (this.record != null) {
            request.addPostParam("Record", this.record.toString());
        }
        if (this.muted != null) {
            request.addPostParam("Muted", this.muted.toString());
        }
        if (this.beep != null) {
            request.addPostParam("Beep", this.beep);
        }
        if (this.startConferenceOnEnter != null) {
            request.addPostParam("StartConferenceOnEnter", this.startConferenceOnEnter.toString());
        }
        if (this.endConferenceOnExit != null) {
            request.addPostParam("EndConferenceOnExit", this.endConferenceOnExit.toString());
        }
        if (this.waitUrl != null) {
            request.addPostParam("WaitUrl", this.waitUrl.toString());
        }
        if (this.waitMethod != null) {
            request.addPostParam("WaitMethod", this.waitMethod.toString());
        }
        if (this.earlyMedia != null) {
            request.addPostParam("EarlyMedia", this.earlyMedia.toString());
        }
        if (this.maxParticipants != null) {
            request.addPostParam("MaxParticipants", this.maxParticipants.toString());
        }
        if (this.conferenceRecord != null) {
            request.addPostParam("ConferenceRecord", this.conferenceRecord);
        }
        if (this.conferenceTrim != null) {
            request.addPostParam("ConferenceTrim", this.conferenceTrim);
        }
        if (this.conferenceStatusCallback != null) {
            request.addPostParam("ConferenceStatusCallback", this.conferenceStatusCallback.toString());
        }
        if (this.conferenceStatusCallbackMethod != null) {
            request.addPostParam("ConferenceStatusCallbackMethod", this.conferenceStatusCallbackMethod.toString());
        }
        if (this.conferenceStatusCallbackEvent != null) {
            for (String prop : this.conferenceStatusCallbackEvent) {
                request.addPostParam("ConferenceStatusCallbackEvent", prop);
            }
        }
        if (this.recordingChannels != null) {
            request.addPostParam("RecordingChannels", this.recordingChannels);
        }
        if (this.recordingStatusCallback != null) {
            request.addPostParam("RecordingStatusCallback", this.recordingStatusCallback.toString());
        }
        if (this.recordingStatusCallbackMethod != null) {
            request.addPostParam("RecordingStatusCallbackMethod", this.recordingStatusCallbackMethod.toString());
        }
        if (this.sipAuthUsername != null) {
            request.addPostParam("SipAuthUsername", this.sipAuthUsername);
        }
        if (this.sipAuthPassword != null) {
            request.addPostParam("SipAuthPassword", this.sipAuthPassword);
        }
        if (this.region != null) {
            request.addPostParam("Region", this.region);
        }
        if (this.conferenceRecordingStatusCallback != null) {
            request.addPostParam("ConferenceRecordingStatusCallback", this.conferenceRecordingStatusCallback.toString());
        }
        if (this.conferenceRecordingStatusCallbackMethod != null) {
            request.addPostParam("ConferenceRecordingStatusCallbackMethod", this.conferenceRecordingStatusCallbackMethod.toString());
        }
        if (this.recordingStatusCallbackEvent != null) {
            for (String prop : this.recordingStatusCallbackEvent) {
                request.addPostParam("RecordingStatusCallbackEvent", prop);
            }
        }
        if (this.conferenceRecordingStatusCallbackEvent != null) {
            for (String prop : this.conferenceRecordingStatusCallbackEvent) {
                request.addPostParam("ConferenceRecordingStatusCallbackEvent", prop);
            }
        }
        if (this.coaching != null) {
            request.addPostParam("Coaching", this.coaching.toString());
        }
        if (this.callSidToCoach != null) {
            request.addPostParam("CallSidToCoach", this.callSidToCoach);
        }
    }
}

