/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.queue;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.queue.MemberFetcher;
import com.twilio.rest.api.v2010.account.queue.MemberReader;
import com.twilio.rest.api.v2010.account.queue.MemberUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Member
extends Resource {
    private static final long serialVersionUID = 8025703048462L;
    private final String callSid;
    private final DateTime dateEnqueued;
    private final Integer position;
    private final String uri;
    private final Integer waitTime;
    private final String queueSid;

    public static MemberFetcher fetcher(String pathAccountSid, String pathQueueSid, String pathCallSid) {
        return new MemberFetcher(pathAccountSid, pathQueueSid, pathCallSid);
    }

    public static MemberFetcher fetcher(String pathQueueSid, String pathCallSid) {
        return new MemberFetcher(pathQueueSid, pathCallSid);
    }

    public static MemberUpdater updater(String pathAccountSid, String pathQueueSid, String pathCallSid, URI url) {
        return new MemberUpdater(pathAccountSid, pathQueueSid, pathCallSid, url);
    }

    public static MemberUpdater updater(String pathQueueSid, String pathCallSid, URI url) {
        return new MemberUpdater(pathQueueSid, pathCallSid, url);
    }

    public static MemberReader reader(String pathAccountSid, String pathQueueSid) {
        return new MemberReader(pathAccountSid, pathQueueSid);
    }

    public static MemberReader reader(String pathQueueSid) {
        return new MemberReader(pathQueueSid);
    }

    public static Member fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Member.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Member fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Member.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Member(@JsonProperty(value="call_sid") String callSid, @JsonProperty(value="date_enqueued") String dateEnqueued, @JsonProperty(value="position") Integer position, @JsonProperty(value="uri") String uri, @JsonProperty(value="wait_time") Integer waitTime, @JsonProperty(value="queue_sid") String queueSid) {
        this.callSid = callSid;
        this.dateEnqueued = DateConverter.rfc2822DateTimeFromString(dateEnqueued);
        this.position = position;
        this.uri = uri;
        this.waitTime = waitTime;
        this.queueSid = queueSid;
    }

    public final String getCallSid() {
        return this.callSid;
    }

    public final DateTime getDateEnqueued() {
        return this.dateEnqueued;
    }

    public final Integer getPosition() {
        return this.position;
    }

    public final String getUri() {
        return this.uri;
    }

    public final Integer getWaitTime() {
        return this.waitTime;
    }

    public final String getQueueSid() {
        return this.queueSid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Member other = (Member)o;
        return Objects.equals(this.callSid, other.callSid) && Objects.equals(this.dateEnqueued, other.dateEnqueued) && Objects.equals(this.position, other.position) && Objects.equals(this.uri, other.uri) && Objects.equals(this.waitTime, other.waitTime) && Objects.equals(this.queueSid, other.queueSid);
    }

    public int hashCode() {
        return Objects.hash(this.callSid, this.dateEnqueued, this.position, this.uri, this.waitTime, this.queueSid);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("callSid", this.callSid).add("dateEnqueued", this.dateEnqueued).add("position", this.position).add("uri", this.uri).add("waitTime", this.waitTime).add("queueSid", this.queueSid).toString();
    }
}

