/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.autopilot.v1.assistant;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.autopilot.v1.assistant.WebhookCreator;
import com.twilio.rest.autopilot.v1.assistant.WebhookDeleter;
import com.twilio.rest.autopilot.v1.assistant.WebhookFetcher;
import com.twilio.rest.autopilot.v1.assistant.WebhookReader;
import com.twilio.rest.autopilot.v1.assistant.WebhookUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Webhook
extends Resource {
    private static final long serialVersionUID = 37970944416419L;
    private final URI url;
    private final String accountSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String assistantSid;
    private final String sid;
    private final String uniqueName;
    private final String events;
    private final URI webhookUrl;
    private final String webhookMethod;

    public static WebhookFetcher fetcher(String pathAssistantSid, String pathSid) {
        return new WebhookFetcher(pathAssistantSid, pathSid);
    }

    public static WebhookReader reader(String pathAssistantSid) {
        return new WebhookReader(pathAssistantSid);
    }

    public static WebhookCreator creator(String pathAssistantSid, String uniqueName, String events, URI webhookUrl) {
        return new WebhookCreator(pathAssistantSid, uniqueName, events, webhookUrl);
    }

    public static WebhookUpdater updater(String pathAssistantSid, String pathSid) {
        return new WebhookUpdater(pathAssistantSid, pathSid);
    }

    public static WebhookDeleter deleter(String pathAssistantSid, String pathSid) {
        return new WebhookDeleter(pathAssistantSid, pathSid);
    }

    public static Webhook fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Webhook.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Webhook fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Webhook.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Webhook(@JsonProperty(value="url") URI url, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="assistant_sid") String assistantSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="events") String events, @JsonProperty(value="webhook_url") URI webhookUrl, @JsonProperty(value="webhook_method") String webhookMethod) {
        this.url = url;
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.assistantSid = assistantSid;
        this.sid = sid;
        this.uniqueName = uniqueName;
        this.events = events;
        this.webhookUrl = webhookUrl;
        this.webhookMethod = webhookMethod;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getAssistantSid() {
        return this.assistantSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final String getEvents() {
        return this.events;
    }

    public final URI getWebhookUrl() {
        return this.webhookUrl;
    }

    public final String getWebhookMethod() {
        return this.webhookMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Webhook other = (Webhook)o;
        return Objects.equals(this.url, other.url) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.assistantSid, other.assistantSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.events, other.events) && Objects.equals(this.webhookUrl, other.webhookUrl) && Objects.equals(this.webhookMethod, other.webhookMethod);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.accountSid, this.dateCreated, this.dateUpdated, this.assistantSid, this.sid, this.uniqueName, this.events, this.webhookUrl, this.webhookMethod);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("url", this.url).add("accountSid", this.accountSid).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("assistantSid", this.assistantSid).add("sid", this.sid).add("uniqueName", this.uniqueName).add("events", this.events).add("webhookUrl", this.webhookUrl).add("webhookMethod", this.webhookMethod).toString();
    }
}

