/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.conversation;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.conversation.Participant;
import org.joda.time.DateTime;

public class ParticipantCreator
extends Creator<Participant> {
    private final String pathConversationSid;
    private String identity;
    private String messagingBindingAddress;
    private String messagingBindingProxyAddress;
    private DateTime dateCreated;
    private DateTime dateUpdated;
    private String attributes;

    public ParticipantCreator(String pathConversationSid) {
        this.pathConversationSid = pathConversationSid;
    }

    public ParticipantCreator setIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    public ParticipantCreator setMessagingBindingAddress(String messagingBindingAddress) {
        this.messagingBindingAddress = messagingBindingAddress;
        return this;
    }

    public ParticipantCreator setMessagingBindingProxyAddress(String messagingBindingProxyAddress) {
        this.messagingBindingProxyAddress = messagingBindingProxyAddress;
        return this;
    }

    public ParticipantCreator setDateCreated(DateTime dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    public ParticipantCreator setDateUpdated(DateTime dateUpdated) {
        this.dateUpdated = dateUpdated;
        return this;
    }

    public ParticipantCreator setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    @Override
    public Participant create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.CONVERSATIONS.toString(), "/v1/Conversations/" + this.pathConversationSid + "/Participants", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Participant creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Participant.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.identity != null) {
            request.addPostParam("Identity", this.identity);
        }
        if (this.messagingBindingAddress != null) {
            request.addPostParam("MessagingBinding.Address", this.messagingBindingAddress);
        }
        if (this.messagingBindingProxyAddress != null) {
            request.addPostParam("MessagingBinding.ProxyAddress", this.messagingBindingProxyAddress);
        }
        if (this.dateCreated != null) {
            request.addPostParam("DateCreated", this.dateCreated.toString());
        }
        if (this.dateUpdated != null) {
            request.addPostParam("DateUpdated", this.dateUpdated.toString());
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
    }
}

