/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.flexapi.v1.FlexFlowCreator;
import com.twilio.rest.flexapi.v1.FlexFlowDeleter;
import com.twilio.rest.flexapi.v1.FlexFlowFetcher;
import com.twilio.rest.flexapi.v1.FlexFlowReader;
import com.twilio.rest.flexapi.v1.FlexFlowUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FlexFlow
extends Resource {
    private static final long serialVersionUID = 100371261398167L;
    private final String accountSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String sid;
    private final String friendlyName;
    private final String chatServiceSid;
    private final ChannelType channelType;
    private final String contactIdentity;
    private final Boolean enabled;
    private final IntegrationType integrationType;
    private final Map<String, Object> integration;
    private final Boolean longLived;
    private final Boolean janitorEnabled;
    private final URI url;

    public static FlexFlowReader reader() {
        return new FlexFlowReader();
    }

    public static FlexFlowFetcher fetcher(String pathSid) {
        return new FlexFlowFetcher(pathSid);
    }

    public static FlexFlowCreator creator(String friendlyName, String chatServiceSid, ChannelType channelType) {
        return new FlexFlowCreator(friendlyName, chatServiceSid, channelType);
    }

    public static FlexFlowUpdater updater(String pathSid) {
        return new FlexFlowUpdater(pathSid);
    }

    public static FlexFlowDeleter deleter(String pathSid) {
        return new FlexFlowDeleter(pathSid);
    }

    public static FlexFlow fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, FlexFlow.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static FlexFlow fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, FlexFlow.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private FlexFlow(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="sid") String sid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="chat_service_sid") String chatServiceSid, @JsonProperty(value="channel_type") ChannelType channelType, @JsonProperty(value="contact_identity") String contactIdentity, @JsonProperty(value="enabled") Boolean enabled, @JsonProperty(value="integration_type") IntegrationType integrationType, @JsonProperty(value="integration") Map<String, Object> integration, @JsonProperty(value="long_lived") Boolean longLived, @JsonProperty(value="janitor_enabled") Boolean janitorEnabled, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.sid = sid;
        this.friendlyName = friendlyName;
        this.chatServiceSid = chatServiceSid;
        this.channelType = channelType;
        this.contactIdentity = contactIdentity;
        this.enabled = enabled;
        this.integrationType = integrationType;
        this.integration = integration;
        this.longLived = longLived;
        this.janitorEnabled = janitorEnabled;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getChatServiceSid() {
        return this.chatServiceSid;
    }

    public final ChannelType getChannelType() {
        return this.channelType;
    }

    public final String getContactIdentity() {
        return this.contactIdentity;
    }

    public final Boolean getEnabled() {
        return this.enabled;
    }

    public final IntegrationType getIntegrationType() {
        return this.integrationType;
    }

    public final Map<String, Object> getIntegration() {
        return this.integration;
    }

    public final Boolean getLongLived() {
        return this.longLived;
    }

    public final Boolean getJanitorEnabled() {
        return this.janitorEnabled;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlexFlow other = (FlexFlow)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.sid, other.sid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.chatServiceSid, other.chatServiceSid) && Objects.equals((Object)this.channelType, (Object)other.channelType) && Objects.equals(this.contactIdentity, other.contactIdentity) && Objects.equals(this.enabled, other.enabled) && Objects.equals((Object)this.integrationType, (Object)other.integrationType) && Objects.equals(this.integration, other.integration) && Objects.equals(this.longLived, other.longLived) && Objects.equals(this.janitorEnabled, other.janitorEnabled) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.dateCreated, this.dateUpdated, this.sid, this.friendlyName, this.chatServiceSid, this.channelType, this.contactIdentity, this.enabled, this.integrationType, this.integration, this.longLived, this.janitorEnabled, this.url});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("sid", this.sid).add("friendlyName", this.friendlyName).add("chatServiceSid", this.chatServiceSid).add("channelType", (Object)this.channelType).add("contactIdentity", this.contactIdentity).add("enabled", this.enabled).add("integrationType", (Object)this.integrationType).add("integration", this.integration).add("longLived", this.longLived).add("janitorEnabled", this.janitorEnabled).add("url", this.url).toString();
    }

    public static enum IntegrationType {
        STUDIO("studio"),
        EXTERNAL("external"),
        TASK("task");

        private final String value;

        private IntegrationType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static IntegrationType forValue(String value) {
            return (IntegrationType)Promoter.enumFromString((String)value, (Enum[])IntegrationType.values());
        }
    }

    public static enum ChannelType {
        WEB("web"),
        SMS("sms"),
        FACEBOOK("facebook"),
        WHATSAPP("whatsapp"),
        LINE("line"),
        CUSTOM("custom");

        private final String value;

        private ChannelType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ChannelType forValue(String value) {
            return (ChannelType)Promoter.enumFromString((String)value, (Enum[])ChannelType.values());
        }
    }
}

