/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.WebChannel;

public class WebChannelCreator
extends Creator<WebChannel> {
    private final String flexFlowSid;
    private final String identity;
    private final String customerFriendlyName;
    private final String chatFriendlyName;
    private String chatUniqueName;
    private String preEngagementData;

    public WebChannelCreator(String flexFlowSid, String identity, String customerFriendlyName, String chatFriendlyName) {
        this.flexFlowSid = flexFlowSid;
        this.identity = identity;
        this.customerFriendlyName = customerFriendlyName;
        this.chatFriendlyName = chatFriendlyName;
    }

    public WebChannelCreator setChatUniqueName(String chatUniqueName) {
        this.chatUniqueName = chatUniqueName;
        return this;
    }

    public WebChannelCreator setPreEngagementData(String preEngagementData) {
        this.preEngagementData = preEngagementData;
        return this;
    }

    @Override
    public WebChannel create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.FLEXAPI.toString(), "/v1/WebChannels", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("WebChannel creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return WebChannel.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.flexFlowSid != null) {
            request.addPostParam("FlexFlowSid", this.flexFlowSid);
        }
        if (this.identity != null) {
            request.addPostParam("Identity", this.identity);
        }
        if (this.customerFriendlyName != null) {
            request.addPostParam("CustomerFriendlyName", this.customerFriendlyName);
        }
        if (this.chatFriendlyName != null) {
            request.addPostParam("ChatFriendlyName", this.chatFriendlyName);
        }
        if (this.chatUniqueName != null) {
            request.addPostParam("ChatUniqueName", this.chatUniqueName);
        }
        if (this.preEngagementData != null) {
            request.addPostParam("PreEngagementData", this.preEngagementData);
        }
    }
}

