/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.flexapi.v1.WebChannel;

public class WebChannelUpdater
extends Updater<WebChannel> {
    private final String pathSid;
    private WebChannel.ChatStatus chatStatus;
    private String postEngagementData;

    public WebChannelUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public WebChannelUpdater setChatStatus(WebChannel.ChatStatus chatStatus) {
        this.chatStatus = chatStatus;
        return this;
    }

    public WebChannelUpdater setPostEngagementData(String postEngagementData) {
        this.postEngagementData = postEngagementData;
        return this;
    }

    @Override
    public WebChannel update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.FLEXAPI.toString(), "/v1/WebChannels/" + this.pathSid + "", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("WebChannel update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return WebChannel.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.chatStatus != null) {
            request.addPostParam("ChatStatus", this.chatStatus.toString());
        }
        if (this.postEngagementData != null) {
            request.addPostParam("PostEngagementData", this.postEngagementData);
        }
    }
}

