/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.messaging.v1.SessionCreator;
import com.twilio.rest.messaging.v1.SessionDeleter;
import com.twilio.rest.messaging.v1.SessionFetcher;
import com.twilio.rest.messaging.v1.SessionReader;
import com.twilio.rest.messaging.v1.SessionUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Session
extends Resource {
    private static final long serialVersionUID = 174532027123268L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final String messagingServiceSid;
    private final String friendlyName;
    private final String attributes;
    private final String createdBy;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;
    private final Map<String, String> links;

    public static SessionFetcher fetcher(String pathSid) {
        return new SessionFetcher(pathSid);
    }

    public static SessionDeleter deleter(String pathSid) {
        return new SessionDeleter(pathSid);
    }

    public static SessionCreator creator(String messagingServiceSid) {
        return new SessionCreator(messagingServiceSid);
    }

    public static SessionUpdater updater(String pathSid) {
        return new SessionUpdater(pathSid);
    }

    public static SessionReader reader() {
        return new SessionReader();
    }

    public static Session fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Session.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Session fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Session.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Session(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="messaging_service_sid") String messagingServiceSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="attributes") String attributes, @JsonProperty(value="created_by") String createdBy, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.messagingServiceSid = messagingServiceSid;
        this.friendlyName = friendlyName;
        this.attributes = attributes;
        this.createdBy = createdBy;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getMessagingServiceSid() {
        return this.messagingServiceSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getAttributes() {
        return this.attributes;
    }

    public final String getCreatedBy() {
        return this.createdBy;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Session other = (Session)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.messagingServiceSid, other.messagingServiceSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.attributes, other.attributes) && Objects.equals(this.createdBy, other.createdBy) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.serviceSid, this.messagingServiceSid, this.friendlyName, this.attributes, this.createdBy, this.dateCreated, this.dateUpdated, this.url, this.links);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("accountSid", this.accountSid).add("serviceSid", this.serviceSid).add("messagingServiceSid", this.messagingServiceSid).add("friendlyName", this.friendlyName).add("attributes", this.attributes).add("createdBy", this.createdBy).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("url", this.url).add("links", this.links).toString();
    }
}

