/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.Session;
import org.joda.time.DateTime;

public class SessionCreator
extends Creator<Session> {
    private final String messagingServiceSid;
    private String friendlyName;
    private String attributes;
    private DateTime dateCreated;
    private DateTime dateUpdated;
    private String createdBy;

    public SessionCreator(String messagingServiceSid) {
        this.messagingServiceSid = messagingServiceSid;
    }

    public SessionCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public SessionCreator setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    public SessionCreator setDateCreated(DateTime dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    public SessionCreator setDateUpdated(DateTime dateUpdated) {
        this.dateUpdated = dateUpdated;
        return this;
    }

    public SessionCreator setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @Override
    public Session create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.MESSAGING.toString(), "/v1/Sessions", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Session creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Session.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.messagingServiceSid != null) {
            request.addPostParam("MessagingServiceSid", this.messagingServiceSid);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
        if (this.dateCreated != null) {
            request.addPostParam("DateCreated", this.dateCreated.toString());
        }
        if (this.dateUpdated != null) {
            request.addPostParam("DateUpdated", this.dateUpdated.toString());
        }
        if (this.createdBy != null) {
            request.addPostParam("CreatedBy", this.createdBy);
        }
    }
}

