/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.Session;

public class SessionFetcher
extends Fetcher<Session> {
    private final String pathSid;

    public SessionFetcher(String pathSid) {
        this.pathSid = pathSid;
    }

    @Override
    public Session fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.MESSAGING.toString(), "/v1/Sessions/" + this.pathSid + "", client.getRegion());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Session fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Session.fromJson(response.getStream(), client.getObjectMapper());
    }
}

