/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.messaging.v1.WebhookFetcher;
import com.twilio.rest.messaging.v1.WebhookUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Webhook
extends Resource {
    private static final long serialVersionUID = 124002729825564L;
    private final String accountSid;
    private final String serviceSid;
    private final String webhookMethod;
    private final List<String> webhookFilters;
    private final String preWebhookUrl;
    private final String postWebhookUrl;
    private final Integer preWebhookRetryCount;
    private final Integer postWebhookRetryCount;
    private final Target target;
    private final URI url;

    public static WebhookFetcher fetcher() {
        return new WebhookFetcher();
    }

    public static WebhookUpdater updater() {
        return new WebhookUpdater();
    }

    public static Webhook fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Webhook.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Webhook fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Webhook.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Webhook(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="webhook_method") String webhookMethod, @JsonProperty(value="webhook_filters") List<String> webhookFilters, @JsonProperty(value="pre_webhook_url") String preWebhookUrl, @JsonProperty(value="post_webhook_url") String postWebhookUrl, @JsonProperty(value="pre_webhook_retry_count") Integer preWebhookRetryCount, @JsonProperty(value="post_webhook_retry_count") Integer postWebhookRetryCount, @JsonProperty(value="target") Target target, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.webhookMethod = webhookMethod;
        this.webhookFilters = webhookFilters;
        this.preWebhookUrl = preWebhookUrl;
        this.postWebhookUrl = postWebhookUrl;
        this.preWebhookRetryCount = preWebhookRetryCount;
        this.postWebhookRetryCount = postWebhookRetryCount;
        this.target = target;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getWebhookMethod() {
        return this.webhookMethod;
    }

    public final List<String> getWebhookFilters() {
        return this.webhookFilters;
    }

    public final String getPreWebhookUrl() {
        return this.preWebhookUrl;
    }

    public final String getPostWebhookUrl() {
        return this.postWebhookUrl;
    }

    public final Integer getPreWebhookRetryCount() {
        return this.preWebhookRetryCount;
    }

    public final Integer getPostWebhookRetryCount() {
        return this.postWebhookRetryCount;
    }

    public final Target getTarget() {
        return this.target;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Webhook other = (Webhook)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.webhookMethod, other.webhookMethod) && Objects.equals(this.webhookFilters, other.webhookFilters) && Objects.equals(this.preWebhookUrl, other.preWebhookUrl) && Objects.equals(this.postWebhookUrl, other.postWebhookUrl) && Objects.equals(this.preWebhookRetryCount, other.preWebhookRetryCount) && Objects.equals(this.postWebhookRetryCount, other.postWebhookRetryCount) && Objects.equals((Object)this.target, (Object)other.target) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.serviceSid, this.webhookMethod, this.webhookFilters, this.preWebhookUrl, this.postWebhookUrl, this.preWebhookRetryCount, this.postWebhookRetryCount, this.target, this.url});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("serviceSid", this.serviceSid).add("webhookMethod", this.webhookMethod).add("webhookFilters", this.webhookFilters).add("preWebhookUrl", this.preWebhookUrl).add("postWebhookUrl", this.postWebhookUrl).add("preWebhookRetryCount", this.preWebhookRetryCount).add("postWebhookRetryCount", this.postWebhookRetryCount).add("target", (Object)this.target).add("url", this.url).toString();
    }

    public static enum Target {
        WEBHOOK("webhook"),
        FLEX("flex");

        private final String value;

        private Target(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Target forValue(String value) {
            return (Target)Promoter.enumFromString((String)value, (Enum[])Target.values());
        }
    }
}

