/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.Webhook;
import java.util.List;

public class WebhookUpdater
extends Updater<Webhook> {
    private String webhookMethod;
    private List<String> webhookFilters;
    private String preWebhookUrl;
    private String postWebhookUrl;
    private Integer preWebhookRetryCount;
    private Integer postWebhookRetryCount;
    private Webhook.Target target;

    public WebhookUpdater setWebhookMethod(String webhookMethod) {
        this.webhookMethod = webhookMethod;
        return this;
    }

    public WebhookUpdater setWebhookFilters(List<String> webhookFilters) {
        this.webhookFilters = webhookFilters;
        return this;
    }

    public WebhookUpdater setWebhookFilters(String webhookFilters) {
        return this.setWebhookFilters(Promoter.listOfOne(webhookFilters));
    }

    public WebhookUpdater setPreWebhookUrl(String preWebhookUrl) {
        this.preWebhookUrl = preWebhookUrl;
        return this;
    }

    public WebhookUpdater setPostWebhookUrl(String postWebhookUrl) {
        this.postWebhookUrl = postWebhookUrl;
        return this;
    }

    public WebhookUpdater setPreWebhookRetryCount(Integer preWebhookRetryCount) {
        this.preWebhookRetryCount = preWebhookRetryCount;
        return this;
    }

    public WebhookUpdater setPostWebhookRetryCount(Integer postWebhookRetryCount) {
        this.postWebhookRetryCount = postWebhookRetryCount;
        return this;
    }

    public WebhookUpdater setTarget(Webhook.Target target) {
        this.target = target;
        return this;
    }

    @Override
    public Webhook update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.MESSAGING.toString(), "/v1/Sessions/Webhooks", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Webhook update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Webhook.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.webhookMethod != null) {
            request.addPostParam("WebhookMethod", this.webhookMethod);
        }
        if (this.webhookFilters != null) {
            for (String prop : this.webhookFilters) {
                request.addPostParam("WebhookFilters", prop);
            }
        }
        if (this.preWebhookUrl != null) {
            request.addPostParam("PreWebhookUrl", this.preWebhookUrl);
        }
        if (this.postWebhookUrl != null) {
            request.addPostParam("PostWebhookUrl", this.postWebhookUrl);
        }
        if (this.preWebhookRetryCount != null) {
            request.addPostParam("PreWebhookRetryCount", this.preWebhookRetryCount.toString());
        }
        if (this.postWebhookRetryCount != null) {
            request.addPostParam("PostWebhookRetryCount", this.postWebhookRetryCount.toString());
        }
        if (this.target != null) {
            request.addPostParam("Target", this.target.toString());
        }
    }
}

