/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1.session;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.messaging.v1.session.MessageCreator;
import com.twilio.rest.messaging.v1.session.MessageDeleter;
import com.twilio.rest.messaging.v1.session.MessageFetcher;
import com.twilio.rest.messaging.v1.session.MessageReader;
import com.twilio.rest.messaging.v1.session.MessageUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Message
extends Resource {
    private static final long serialVersionUID = 267169563214895L;
    private final String accountSid;
    private final String serviceSid;
    private final String messagingServiceSid;
    private final String sessionSid;
    private final String sid;
    private final Integer index;
    private final String author;
    private final String body;
    private final String attributes;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;

    public static MessageFetcher fetcher(String pathSessionSid, String pathSid) {
        return new MessageFetcher(pathSessionSid, pathSid);
    }

    public static MessageCreator creator(String pathSessionSid) {
        return new MessageCreator(pathSessionSid);
    }

    public static MessageUpdater updater(String pathSessionSid, String pathSid) {
        return new MessageUpdater(pathSessionSid, pathSid);
    }

    public static MessageReader reader(String pathSessionSid) {
        return new MessageReader(pathSessionSid);
    }

    public static MessageDeleter deleter(String pathSessionSid, String pathSid) {
        return new MessageDeleter(pathSessionSid, pathSid);
    }

    public static Message fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Message.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Message fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Message.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Message(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="messaging_service_sid") String messagingServiceSid, @JsonProperty(value="session_sid") String sessionSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="index") Integer index, @JsonProperty(value="author") String author, @JsonProperty(value="body") String body, @JsonProperty(value="attributes") String attributes, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.messagingServiceSid = messagingServiceSid;
        this.sessionSid = sessionSid;
        this.sid = sid;
        this.index = index;
        this.author = author;
        this.body = body;
        this.attributes = attributes;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getMessagingServiceSid() {
        return this.messagingServiceSid;
    }

    public final String getSessionSid() {
        return this.sessionSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final Integer getIndex() {
        return this.index;
    }

    public final String getAuthor() {
        return this.author;
    }

    public final String getBody() {
        return this.body;
    }

    public final String getAttributes() {
        return this.attributes;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message other = (Message)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.messagingServiceSid, other.messagingServiceSid) && Objects.equals(this.sessionSid, other.sessionSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.index, other.index) && Objects.equals(this.author, other.author) && Objects.equals(this.body, other.body) && Objects.equals(this.attributes, other.attributes) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.serviceSid, this.messagingServiceSid, this.sessionSid, this.sid, this.index, this.author, this.body, this.attributes, this.dateCreated, this.dateUpdated, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("serviceSid", this.serviceSid).add("messagingServiceSid", this.messagingServiceSid).add("sessionSid", this.sessionSid).add("sid", this.sid).add("index", this.index).add("author", this.author).add("body", this.body).add("attributes", this.attributes).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("url", this.url).toString();
    }
}

