/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1.session;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.messaging.v1.session.ParticipantCreator;
import com.twilio.rest.messaging.v1.session.ParticipantDeleter;
import com.twilio.rest.messaging.v1.session.ParticipantFetcher;
import com.twilio.rest.messaging.v1.session.ParticipantReader;
import com.twilio.rest.messaging.v1.session.ParticipantUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Participant
extends Resource {
    private static final long serialVersionUID = 38286874885630L;
    private final String accountSid;
    private final String serviceSid;
    private final String messagingServiceSid;
    private final String sessionSid;
    private final String sid;
    private final String identity;
    private final String twilioAddress;
    private final String userAddress;
    private final String attributes;
    private final ParticipantType type;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;

    public static ParticipantCreator creator(String pathSessionSid) {
        return new ParticipantCreator(pathSessionSid);
    }

    public static ParticipantUpdater updater(String pathSessionSid, String pathSid) {
        return new ParticipantUpdater(pathSessionSid, pathSid);
    }

    public static ParticipantFetcher fetcher(String pathSessionSid, String pathSid) {
        return new ParticipantFetcher(pathSessionSid, pathSid);
    }

    public static ParticipantReader reader(String pathSessionSid) {
        return new ParticipantReader(pathSessionSid);
    }

    public static ParticipantDeleter deleter(String pathSessionSid, String pathSid) {
        return new ParticipantDeleter(pathSessionSid, pathSid);
    }

    public static Participant fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Participant.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Participant fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Participant.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Participant(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="messaging_service_sid") String messagingServiceSid, @JsonProperty(value="session_sid") String sessionSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="identity") String identity, @JsonProperty(value="twilio_address") String twilioAddress, @JsonProperty(value="user_address") String userAddress, @JsonProperty(value="attributes") String attributes, @JsonProperty(value="type") ParticipantType type, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.messagingServiceSid = messagingServiceSid;
        this.sessionSid = sessionSid;
        this.sid = sid;
        this.identity = identity;
        this.twilioAddress = twilioAddress;
        this.userAddress = userAddress;
        this.attributes = attributes;
        this.type = type;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getMessagingServiceSid() {
        return this.messagingServiceSid;
    }

    public final String getSessionSid() {
        return this.sessionSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getIdentity() {
        return this.identity;
    }

    public final String getTwilioAddress() {
        return this.twilioAddress;
    }

    public final String getUserAddress() {
        return this.userAddress;
    }

    public final String getAttributes() {
        return this.attributes;
    }

    public final ParticipantType getType() {
        return this.type;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Participant other = (Participant)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.messagingServiceSid, other.messagingServiceSid) && Objects.equals(this.sessionSid, other.sessionSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.identity, other.identity) && Objects.equals(this.twilioAddress, other.twilioAddress) && Objects.equals(this.userAddress, other.userAddress) && Objects.equals(this.attributes, other.attributes) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.serviceSid, this.messagingServiceSid, this.sessionSid, this.sid, this.identity, this.twilioAddress, this.userAddress, this.attributes, this.type, this.dateCreated, this.dateUpdated, this.url});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("serviceSid", this.serviceSid).add("messagingServiceSid", this.messagingServiceSid).add("sessionSid", this.sessionSid).add("sid", this.sid).add("identity", this.identity).add("twilioAddress", this.twilioAddress).add("userAddress", this.userAddress).add("attributes", this.attributes).add("type", (Object)this.type).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("url", this.url).toString();
    }

    public static enum ParticipantType {
        CHAT("chat"),
        SMS("sms");

        private final String value;

        private ParticipantType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ParticipantType forValue(String value) {
            return (ParticipantType)Promoter.enumFromString((String)value, (Enum[])ParticipantType.values());
        }
    }
}

