/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1.session;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.session.Participant;
import org.joda.time.DateTime;

public class ParticipantCreator
extends Creator<Participant> {
    private final String pathSessionSid;
    private String identity;
    private String userAddress;
    private String attributes;
    private String twilioAddress;
    private DateTime dateCreated;
    private DateTime dateUpdated;

    public ParticipantCreator(String pathSessionSid) {
        this.pathSessionSid = pathSessionSid;
    }

    public ParticipantCreator setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    public ParticipantCreator setTwilioAddress(String twilioAddress) {
        this.twilioAddress = twilioAddress;
        return this;
    }

    public ParticipantCreator setDateCreated(DateTime dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    public ParticipantCreator setDateUpdated(DateTime dateUpdated) {
        this.dateUpdated = dateUpdated;
        return this;
    }

    public ParticipantCreator setIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    public ParticipantCreator setUserAddress(String userAddress) {
        this.userAddress = userAddress;
        return this;
    }

    @Override
    public Participant create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.MESSAGING.toString(), "/v1/Sessions/" + this.pathSessionSid + "/Participants", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Participant creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Participant.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.identity != null) {
            request.addPostParam("Identity", this.identity);
        }
        if (this.userAddress != null) {
            request.addPostParam("UserAddress", this.userAddress);
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
        if (this.twilioAddress != null) {
            request.addPostParam("TwilioAddress", this.twilioAddress);
        }
        if (this.dateCreated != null) {
            request.addPostParam("DateCreated", this.dateCreated.toString());
        }
        if (this.dateUpdated != null) {
            request.addPostParam("DateUpdated", this.dateUpdated.toString());
        }
    }
}

