/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1.session;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.session.Participant;
import org.joda.time.DateTime;

public class ParticipantUpdater
extends Updater<Participant> {
    private final String pathSessionSid;
    private final String pathSid;
    private String attributes;
    private DateTime dateCreated;
    private DateTime dateUpdated;

    public ParticipantUpdater(String pathSessionSid, String pathSid) {
        this.pathSessionSid = pathSessionSid;
        this.pathSid = pathSid;
    }

    public ParticipantUpdater setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    public ParticipantUpdater setDateCreated(DateTime dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    public ParticipantUpdater setDateUpdated(DateTime dateUpdated) {
        this.dateUpdated = dateUpdated;
        return this;
    }

    @Override
    public Participant update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.MESSAGING.toString(), "/v1/Sessions/" + this.pathSessionSid + "/Participants/" + this.pathSid + "", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Participant update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Participant.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
        if (this.dateCreated != null) {
            request.addPostParam("DateCreated", this.dateCreated.toString());
        }
        if (this.dateUpdated != null) {
            request.addPostParam("DateUpdated", this.dateUpdated.toString());
        }
    }
}

