/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1.session;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.messaging.v1.session.WebhookCreator;
import com.twilio.rest.messaging.v1.session.WebhookDeleter;
import com.twilio.rest.messaging.v1.session.WebhookFetcher;
import com.twilio.rest.messaging.v1.session.WebhookReader;
import com.twilio.rest.messaging.v1.session.WebhookUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Webhook
extends Resource {
    private static final long serialVersionUID = 109054084241115L;
    private final String sid;
    private final String accountSid;
    private final String sessionSid;
    private final String target;
    private final URI url;
    private final Map<String, Object> configuration;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;

    public static WebhookReader reader(String pathSessionSid) {
        return new WebhookReader(pathSessionSid);
    }

    public static WebhookFetcher fetcher(String pathSessionSid, String pathSid) {
        return new WebhookFetcher(pathSessionSid, pathSid);
    }

    public static WebhookCreator creator(String pathSessionSid, Target target) {
        return new WebhookCreator(pathSessionSid, target);
    }

    public static WebhookUpdater updater(String pathSessionSid, String pathSid) {
        return new WebhookUpdater(pathSessionSid, pathSid);
    }

    public static WebhookDeleter deleter(String pathSessionSid, String pathSid) {
        return new WebhookDeleter(pathSessionSid, pathSid);
    }

    public static Webhook fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Webhook.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Webhook fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Webhook.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Webhook(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="session_sid") String sessionSid, @JsonProperty(value="target") String target, @JsonProperty(value="url") URI url, @JsonProperty(value="configuration") Map<String, Object> configuration, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.sessionSid = sessionSid;
        this.target = target;
        this.url = url;
        this.configuration = configuration;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getSessionSid() {
        return this.sessionSid;
    }

    public final String getTarget() {
        return this.target;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Webhook other = (Webhook)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.sessionSid, other.sessionSid) && Objects.equals(this.target, other.target) && Objects.equals(this.url, other.url) && Objects.equals(this.configuration, other.configuration) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.sessionSid, this.target, this.url, this.configuration, this.dateCreated, this.dateUpdated);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("accountSid", this.accountSid).add("sessionSid", this.sessionSid).add("target", this.target).add("url", this.url).add("configuration", this.configuration).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).toString();
    }

    public static enum Method {
        GET("GET"),
        POST("POST");

        private final String value;

        private Method(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Method forValue(String value) {
            return (Method)Promoter.enumFromString((String)value, (Enum[])Method.values());
        }
    }

    public static enum Target {
        WEBHOOK("webhook"),
        TRIGGER("trigger"),
        STUDIO("studio");

        private final String value;

        private Target(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Target forValue(String value) {
            return (Target)Promoter.enumFromString((String)value, (Enum[])Target.values());
        }
    }
}

