/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.marketplace.availableaddon;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.marketplace.availableaddon.AvailableAddOnExtensionFetcher;
import com.twilio.rest.preview.marketplace.availableaddon.AvailableAddOnExtensionReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AvailableAddOnExtension
extends Resource {
    private static final long serialVersionUID = 88592059649526L;
    private final String sid;
    private final String availableAddOnSid;
    private final String friendlyName;
    private final String productName;
    private final String uniqueName;
    private final URI url;

    public static AvailableAddOnExtensionFetcher fetcher(String pathAvailableAddOnSid, String pathSid) {
        return new AvailableAddOnExtensionFetcher(pathAvailableAddOnSid, pathSid);
    }

    public static AvailableAddOnExtensionReader reader(String pathAvailableAddOnSid) {
        return new AvailableAddOnExtensionReader(pathAvailableAddOnSid);
    }

    public static AvailableAddOnExtension fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, AvailableAddOnExtension.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static AvailableAddOnExtension fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, AvailableAddOnExtension.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private AvailableAddOnExtension(@JsonProperty(value="sid") String sid, @JsonProperty(value="available_add_on_sid") String availableAddOnSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="product_name") String productName, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.availableAddOnSid = availableAddOnSid;
        this.friendlyName = friendlyName;
        this.productName = productName;
        this.uniqueName = uniqueName;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAvailableAddOnSid() {
        return this.availableAddOnSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getProductName() {
        return this.productName;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvailableAddOnExtension other = (AvailableAddOnExtension)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.availableAddOnSid, other.availableAddOnSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.productName, other.productName) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.availableAddOnSid, this.friendlyName, this.productName, this.uniqueName, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("availableAddOnSid", this.availableAddOnSid).add("friendlyName", this.friendlyName).add("productName", this.productName).add("uniqueName", this.uniqueName).add("url", this.url).toString();
    }
}

