/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.trustedComms;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.trustedComms.BrandedCallCreator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BrandedCall
extends Resource {
    private static final long serialVersionUID = 186540956820921L;
    private final String accountSid;
    private final String bgColor;
    private final String caller;
    private final DateTime createdAt;
    private final String fontColor;
    private final String from;
    private final String logo;
    private final String reason;
    private final String sid;
    private final String status;
    private final String to;
    private final URI url;
    private final String useCase;

    public static BrandedCallCreator creator(String from, String to, String reason) {
        return new BrandedCallCreator(from, to, reason);
    }

    public static BrandedCall fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, BrandedCall.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static BrandedCall fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, BrandedCall.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private BrandedCall(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="bg_color") String bgColor, @JsonProperty(value="caller") String caller, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="font_color") String fontColor, @JsonProperty(value="from") String from, @JsonProperty(value="logo") String logo, @JsonProperty(value="reason") String reason, @JsonProperty(value="sid") String sid, @JsonProperty(value="status") String status, @JsonProperty(value="to") String to, @JsonProperty(value="url") URI url, @JsonProperty(value="use_case") String useCase) {
        this.accountSid = accountSid;
        this.bgColor = bgColor;
        this.caller = caller;
        this.createdAt = DateConverter.iso8601DateTimeFromString(createdAt);
        this.fontColor = fontColor;
        this.from = from;
        this.logo = logo;
        this.reason = reason;
        this.sid = sid;
        this.status = status;
        this.to = to;
        this.url = url;
        this.useCase = useCase;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getBgColor() {
        return this.bgColor;
    }

    public final String getCaller() {
        return this.caller;
    }

    public final DateTime getCreatedAt() {
        return this.createdAt;
    }

    public final String getFontColor() {
        return this.fontColor;
    }

    public final String getFrom() {
        return this.from;
    }

    public final String getLogo() {
        return this.logo;
    }

    public final String getReason() {
        return this.reason;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getStatus() {
        return this.status;
    }

    public final String getTo() {
        return this.to;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final String getUseCase() {
        return this.useCase;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrandedCall other = (BrandedCall)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.bgColor, other.bgColor) && Objects.equals(this.caller, other.caller) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.fontColor, other.fontColor) && Objects.equals(this.from, other.from) && Objects.equals(this.logo, other.logo) && Objects.equals(this.reason, other.reason) && Objects.equals(this.sid, other.sid) && Objects.equals(this.status, other.status) && Objects.equals(this.to, other.to) && Objects.equals(this.url, other.url) && Objects.equals(this.useCase, other.useCase);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.bgColor, this.caller, this.createdAt, this.fontColor, this.from, this.logo, this.reason, this.sid, this.status, this.to, this.url, this.useCase);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("bgColor", this.bgColor).add("caller", this.caller).add("createdAt", this.createdAt).add("fontColor", this.fontColor).add("from", this.from).add("logo", this.logo).add("reason", this.reason).add("sid", this.sid).add("status", this.status).add("to", this.to).add("url", this.url).add("useCase", this.useCase).toString();
    }
}

