/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.trustedComms;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.trustedComms.CpsFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Cps
extends Resource {
    private static final long serialVersionUID = 222355853485460L;
    private final String phoneNumber;
    private final URI cpsUrl;
    private final URI url;

    public static CpsFetcher fetcher() {
        return new CpsFetcher();
    }

    public static Cps fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Cps.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Cps fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Cps.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Cps(@JsonProperty(value="phone_number") String phoneNumber, @JsonProperty(value="cps_url") URI cpsUrl, @JsonProperty(value="url") URI url) {
        this.phoneNumber = phoneNumber;
        this.cpsUrl = cpsUrl;
        this.url = url;
    }

    public final String getPhoneNumber() {
        return this.phoneNumber;
    }

    public final URI getCpsUrl() {
        return this.cpsUrl;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cps other = (Cps)o;
        return Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.cpsUrl, other.cpsUrl) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.phoneNumber, this.cpsUrl, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("phoneNumber", this.phoneNumber).add("cpsUrl", this.cpsUrl).add("url", this.url).toString();
    }
}

