/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.trustedComms;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.trustedComms.CurrentCallFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CurrentCall
extends Resource {
    private static final long serialVersionUID = 212286172550611L;
    private final String sid;
    private final String from;
    private final String to;
    private final String status;
    private final String reason;
    private final DateTime createdAt;
    private final String caller;
    private final String logo;
    private final String bgColor;
    private final String fontColor;
    private final String useCase;
    private final String manager;
    private final String shieldImg;
    private final URI url;

    public static CurrentCallFetcher fetcher() {
        return new CurrentCallFetcher();
    }

    public static CurrentCall fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, CurrentCall.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static CurrentCall fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, CurrentCall.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private CurrentCall(@JsonProperty(value="sid") String sid, @JsonProperty(value="from") String from, @JsonProperty(value="to") String to, @JsonProperty(value="status") String status, @JsonProperty(value="reason") String reason, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="caller") String caller, @JsonProperty(value="logo") String logo, @JsonProperty(value="bg_color") String bgColor, @JsonProperty(value="font_color") String fontColor, @JsonProperty(value="use_case") String useCase, @JsonProperty(value="manager") String manager, @JsonProperty(value="shield_img") String shieldImg, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.from = from;
        this.to = to;
        this.status = status;
        this.reason = reason;
        this.createdAt = DateConverter.iso8601DateTimeFromString(createdAt);
        this.caller = caller;
        this.logo = logo;
        this.bgColor = bgColor;
        this.fontColor = fontColor;
        this.useCase = useCase;
        this.manager = manager;
        this.shieldImg = shieldImg;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getFrom() {
        return this.from;
    }

    public final String getTo() {
        return this.to;
    }

    public final String getStatus() {
        return this.status;
    }

    public final String getReason() {
        return this.reason;
    }

    public final DateTime getCreatedAt() {
        return this.createdAt;
    }

    public final String getCaller() {
        return this.caller;
    }

    public final String getLogo() {
        return this.logo;
    }

    public final String getBgColor() {
        return this.bgColor;
    }

    public final String getFontColor() {
        return this.fontColor;
    }

    public final String getUseCase() {
        return this.useCase;
    }

    public final String getManager() {
        return this.manager;
    }

    public final String getShieldImg() {
        return this.shieldImg;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CurrentCall other = (CurrentCall)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to) && Objects.equals(this.status, other.status) && Objects.equals(this.reason, other.reason) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.caller, other.caller) && Objects.equals(this.logo, other.logo) && Objects.equals(this.bgColor, other.bgColor) && Objects.equals(this.fontColor, other.fontColor) && Objects.equals(this.useCase, other.useCase) && Objects.equals(this.manager, other.manager) && Objects.equals(this.shieldImg, other.shieldImg) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.from, this.to, this.status, this.reason, this.createdAt, this.caller, this.logo, this.bgColor, this.fontColor, this.useCase, this.manager, this.shieldImg, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("from", this.from).add("to", this.to).add("status", this.status).add("reason", this.reason).add("createdAt", this.createdAt).add("caller", this.caller).add("logo", this.logo).add("bgColor", this.bgColor).add("fontColor", this.fontColor).add("useCase", this.useCase).add("manager", this.manager).add("shieldImg", this.shieldImg).add("url", this.url).toString();
    }
}

