/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.trustedComms;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.trustedComms.DeviceCreator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Device
extends Resource {
    private static final long serialVersionUID = 45132712110033L;
    private final String sid;
    private final String phoneNumber;
    private final String bindingSid;
    private final URI url;

    public static DeviceCreator creator(String phoneNumber, String pushToken) {
        return new DeviceCreator(phoneNumber, pushToken);
    }

    public static Device fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Device.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Device fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Device.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Device(@JsonProperty(value="sid") String sid, @JsonProperty(value="phone_number") String phoneNumber, @JsonProperty(value="binding_sid") String bindingSid, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.phoneNumber = phoneNumber;
        this.bindingSid = bindingSid;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getPhoneNumber() {
        return this.phoneNumber;
    }

    public final String getBindingSid() {
        return this.bindingSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Device other = (Device)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.bindingSid, other.bindingSid) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.phoneNumber, this.bindingSid, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("phoneNumber", this.phoneNumber).add("bindingSid", this.bindingSid).add("url", this.url).toString();
    }
}

