/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.trustedComms;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.trustedComms.Device;

public class DeviceCreator
extends Creator<Device> {
    private final String phoneNumber;
    private final String pushToken;

    public DeviceCreator(String phoneNumber, String pushToken) {
        this.phoneNumber = phoneNumber;
        this.pushToken = pushToken;
    }

    @Override
    public Device create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), "/TrustedComms/Devices", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Device creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Device.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.phoneNumber != null) {
            request.addPostParam("PhoneNumber", this.phoneNumber);
        }
        if (this.pushToken != null) {
            request.addPostParam("PushToken", this.pushToken);
        }
    }
}

