/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.trustedComms;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.trustedComms.PhoneCallCreator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PhoneCall
extends Resource {
    private static final long serialVersionUID = 32659331953626L;
    private final String sid;
    private final String accountSid;
    private final String from;
    private final String to;
    private final String reason;
    private final DateTime createdAt;
    private final URI url;

    public static PhoneCallCreator creator(String from, String to) {
        return new PhoneCallCreator(from, to);
    }

    public static PhoneCall fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, PhoneCall.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static PhoneCall fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, PhoneCall.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private PhoneCall(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="from") String from, @JsonProperty(value="to") String to, @JsonProperty(value="reason") String reason, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.from = from;
        this.to = to;
        this.reason = reason;
        this.createdAt = DateConverter.iso8601DateTimeFromString(createdAt);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFrom() {
        return this.from;
    }

    public final String getTo() {
        return this.to;
    }

    public final String getReason() {
        return this.reason;
    }

    public final DateTime getCreatedAt() {
        return this.createdAt;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhoneCall other = (PhoneCall)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to) && Objects.equals(this.reason, other.reason) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.from, this.to, this.reason, this.createdAt, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("accountSid", this.accountSid).add("from", this.from).add("to", this.to).add("reason", this.reason).add("createdAt", this.createdAt).add("url", this.url).toString();
    }
}

