/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.proxy.v1.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.proxy.v1.service.PhoneNumberCreator;
import com.twilio.rest.proxy.v1.service.PhoneNumberDeleter;
import com.twilio.rest.proxy.v1.service.PhoneNumberFetcher;
import com.twilio.rest.proxy.v1.service.PhoneNumberReader;
import com.twilio.rest.proxy.v1.service.PhoneNumberUpdater;
import com.twilio.type.PhoneNumberCapabilities;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PhoneNumber
extends Resource {
    private static final long serialVersionUID = 107544964482709L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final com.twilio.type.PhoneNumber phoneNumber;
    private final String friendlyName;
    private final String isoCountry;
    private final PhoneNumberCapabilities capabilities;
    private final URI url;
    private final Boolean isReserved;
    private final Integer inUse;

    public static PhoneNumberCreator creator(String pathServiceSid) {
        return new PhoneNumberCreator(pathServiceSid);
    }

    public static PhoneNumberDeleter deleter(String pathServiceSid, String pathSid) {
        return new PhoneNumberDeleter(pathServiceSid, pathSid);
    }

    public static PhoneNumberReader reader(String pathServiceSid) {
        return new PhoneNumberReader(pathServiceSid);
    }

    public static PhoneNumberFetcher fetcher(String pathServiceSid, String pathSid) {
        return new PhoneNumberFetcher(pathServiceSid, pathSid);
    }

    public static PhoneNumberUpdater updater(String pathServiceSid, String pathSid) {
        return new PhoneNumberUpdater(pathServiceSid, pathSid);
    }

    public static PhoneNumber fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, PhoneNumber.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static PhoneNumber fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, PhoneNumber.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private PhoneNumber(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="phone_number") com.twilio.type.PhoneNumber phoneNumber, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="iso_country") String isoCountry, @JsonProperty(value="capabilities") PhoneNumberCapabilities capabilities, @JsonProperty(value="url") URI url, @JsonProperty(value="is_reserved") Boolean isReserved, @JsonProperty(value="in_use") Integer inUse) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.phoneNumber = phoneNumber;
        this.friendlyName = friendlyName;
        this.isoCountry = isoCountry;
        this.capabilities = capabilities;
        this.url = url;
        this.isReserved = isReserved;
        this.inUse = inUse;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final com.twilio.type.PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getIsoCountry() {
        return this.isoCountry;
    }

    public final PhoneNumberCapabilities getCapabilities() {
        return this.capabilities;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Boolean getIsReserved() {
        return this.isReserved;
    }

    public final Integer getInUse() {
        return this.inUse;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhoneNumber other = (PhoneNumber)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.isoCountry, other.isoCountry) && Objects.equals(this.capabilities, other.capabilities) && Objects.equals(this.url, other.url) && Objects.equals(this.isReserved, other.isReserved) && Objects.equals(this.inUse, other.inUse);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.serviceSid, this.dateCreated, this.dateUpdated, this.phoneNumber, this.friendlyName, this.isoCountry, this.capabilities, this.url, this.isReserved, this.inUse);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("accountSid", this.accountSid).add("serviceSid", this.serviceSid).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("phoneNumber", this.phoneNumber).add("friendlyName", this.friendlyName).add("isoCountry", this.isoCountry).add("capabilities", this.capabilities).add("url", this.url).add("isReserved", this.isReserved).add("inUse", this.inUse).toString();
    }
}

