/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.proxy.v1.service;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.proxy.v1.service.Session;
import org.joda.time.DateTime;

public class SessionUpdater
extends Updater<Session> {
    private final String pathServiceSid;
    private final String pathSid;
    private DateTime dateExpiry;
    private Integer ttl;
    private Session.Status status;

    public SessionUpdater(String pathServiceSid, String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathSid = pathSid;
    }

    public SessionUpdater setDateExpiry(DateTime dateExpiry) {
        this.dateExpiry = dateExpiry;
        return this;
    }

    public SessionUpdater setTtl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    public SessionUpdater setStatus(Session.Status status) {
        this.status = status;
        return this;
    }

    @Override
    public Session update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.PROXY.toString(), "/v1/Services/" + this.pathServiceSid + "/Sessions/" + this.pathSid + "", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Session update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Session.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.dateExpiry != null) {
            request.addPostParam("DateExpiry", this.dateExpiry.toString());
        }
        if (this.ttl != null) {
            request.addPostParam("Ttl", this.ttl.toString());
        }
        if (this.status != null) {
            request.addPostParam("Status", this.status.toString());
        }
    }
}

