/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.serverless.v1;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.serverless.v1.Service;

public class ServiceCreator
extends Creator<Service> {
    private final String uniqueName;
    private final String friendlyName;
    private Boolean includeCredentials;

    public ServiceCreator(String uniqueName, String friendlyName) {
        this.uniqueName = uniqueName;
        this.friendlyName = friendlyName;
    }

    public ServiceCreator setIncludeCredentials(Boolean includeCredentials) {
        this.includeCredentials = includeCredentials;
        return this;
    }

    @Override
    public Service create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.SERVERLESS.toString(), "/v1/Services", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Service creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Service.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.includeCredentials != null) {
            request.addPostParam("IncludeCredentials", this.includeCredentials.toString());
        }
    }
}

