/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.serverless.v1.service;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.serverless.v1.service.Environment;

public class EnvironmentCreator
extends Creator<Environment> {
    private final String pathServiceSid;
    private final String uniqueName;
    private String domainSuffix;

    public EnvironmentCreator(String pathServiceSid, String uniqueName) {
        this.pathServiceSid = pathServiceSid;
        this.uniqueName = uniqueName;
    }

    public EnvironmentCreator setDomainSuffix(String domainSuffix) {
        this.domainSuffix = domainSuffix;
        return this;
    }

    @Override
    public Environment create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.SERVERLESS.toString(), "/v1/Services/" + this.pathServiceSid + "/Environments", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Environment creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Environment.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.domainSuffix != null) {
            request.addPostParam("DomainSuffix", this.domainSuffix);
        }
    }
}

