/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.serverless.v1.service;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.serverless.v1.service.Environment;

public class EnvironmentReader
extends Reader<Environment> {
    private final String pathServiceSid;

    public EnvironmentReader(String pathServiceSid) {
        this.pathServiceSid = pathServiceSid;
    }

    @Override
    public ResourceSet<Environment> read(TwilioRestClient client) {
        return new ResourceSet<Environment>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Environment> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.SERVERLESS.toString(), "/v1/Services/" + this.pathServiceSid + "/Environments", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Environment> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Environment> nextPage(Page<Environment> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.SERVERLESS.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Environment> previousPage(Page<Environment> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.SERVERLESS.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Environment> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Environment read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("environments", response.getContent(), Environment.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

