/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.serverless.v1.service.environment;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.serverless.v1.service.environment.Log;

public class LogFetcher
extends Fetcher<Log> {
    private final String pathServiceSid;
    private final String pathEnvironmentSid;
    private final String pathSid;

    public LogFetcher(String pathServiceSid, String pathEnvironmentSid, String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathEnvironmentSid = pathEnvironmentSid;
        this.pathSid = pathSid;
    }

    @Override
    public Log fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.SERVERLESS.toString(), "/v1/Services/" + this.pathServiceSid + "/Environments/" + this.pathEnvironmentSid + "/Logs/" + this.pathSid + "", client.getRegion());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Log fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Log.fromJson(response.getStream(), client.getObjectMapper());
    }
}

