/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.serverless.v1.service.environment;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.serverless.v1.service.environment.Variable;

public class VariableCreator
extends Creator<Variable> {
    private final String pathServiceSid;
    private final String pathEnvironmentSid;
    private final String key;
    private final String value;

    public VariableCreator(String pathServiceSid, String pathEnvironmentSid, String key, String value) {
        this.pathServiceSid = pathServiceSid;
        this.pathEnvironmentSid = pathEnvironmentSid;
        this.key = key;
        this.value = value;
    }

    @Override
    public Variable create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.SERVERLESS.toString(), "/v1/Services/" + this.pathServiceSid + "/Environments/" + this.pathEnvironmentSid + "/Variables", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Variable creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Variable.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.key != null) {
            request.addPostParam("Key", this.key);
        }
        if (this.value != null) {
            request.addPostParam("Value", this.value);
        }
    }
}

