/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.serverless.v1.service.function;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.serverless.v1.service.function.FunctionVersionFetcher;
import com.twilio.rest.serverless.v1.service.function.FunctionVersionReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FunctionVersion
extends Resource {
    private static final long serialVersionUID = 219697752660692L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final String functionSid;
    private final String path;
    private final Visibility visibility;
    private final DateTime dateCreated;
    private final URI url;

    public static FunctionVersionReader reader(String pathServiceSid, String pathFunctionSid) {
        return new FunctionVersionReader(pathServiceSid, pathFunctionSid);
    }

    public static FunctionVersionFetcher fetcher(String pathServiceSid, String pathFunctionSid, String pathSid) {
        return new FunctionVersionFetcher(pathServiceSid, pathFunctionSid, pathSid);
    }

    public static FunctionVersion fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, FunctionVersion.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static FunctionVersion fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, FunctionVersion.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private FunctionVersion(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="function_sid") String functionSid, @JsonProperty(value="path") String path, @JsonProperty(value="visibility") Visibility visibility, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.functionSid = functionSid;
        this.path = path;
        this.visibility = visibility;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getFunctionSid() {
        return this.functionSid;
    }

    public final String getPath() {
        return this.path;
    }

    public final Visibility getVisibility() {
        return this.visibility;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionVersion other = (FunctionVersion)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.functionSid, other.functionSid) && Objects.equals(this.path, other.path) && Objects.equals((Object)this.visibility, (Object)other.visibility) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.serviceSid, this.functionSid, this.path, this.visibility, this.dateCreated, this.url});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("accountSid", this.accountSid).add("serviceSid", this.serviceSid).add("functionSid", this.functionSid).add("path", this.path).add("visibility", (Object)this.visibility).add("dateCreated", this.dateCreated).add("url", this.url).toString();
    }

    public static enum Visibility {
        PUBLIC("public"),
        PRIVATE("private"),
        PROTECTED("protected");

        private final String value;

        private Visibility(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Visibility forValue(String value) {
            return (Visibility)Promoter.enumFromString((String)value, (Enum[])Visibility.values());
        }
    }
}

