/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.taskrouter.v1.workspace.TaskChannelCreator;
import com.twilio.rest.taskrouter.v1.workspace.TaskChannelDeleter;
import com.twilio.rest.taskrouter.v1.workspace.TaskChannelFetcher;
import com.twilio.rest.taskrouter.v1.workspace.TaskChannelReader;
import com.twilio.rest.taskrouter.v1.workspace.TaskChannelUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TaskChannel
extends Resource {
    private static final long serialVersionUID = 87520156212725L;
    private final String accountSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String friendlyName;
    private final String sid;
    private final String uniqueName;
    private final String workspaceSid;
    private final Boolean channelOptimizedRouting;
    private final URI url;
    private final Map<String, String> links;

    public static TaskChannelFetcher fetcher(String pathWorkspaceSid, String pathSid) {
        return new TaskChannelFetcher(pathWorkspaceSid, pathSid);
    }

    public static TaskChannelReader reader(String pathWorkspaceSid) {
        return new TaskChannelReader(pathWorkspaceSid);
    }

    public static TaskChannelUpdater updater(String pathWorkspaceSid, String pathSid) {
        return new TaskChannelUpdater(pathWorkspaceSid, pathSid);
    }

    public static TaskChannelDeleter deleter(String pathWorkspaceSid, String pathSid) {
        return new TaskChannelDeleter(pathWorkspaceSid, pathSid);
    }

    public static TaskChannelCreator creator(String pathWorkspaceSid, String friendlyName, String uniqueName) {
        return new TaskChannelCreator(pathWorkspaceSid, friendlyName, uniqueName);
    }

    public static TaskChannel fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, TaskChannel.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static TaskChannel fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, TaskChannel.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private TaskChannel(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="sid") String sid, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="workspace_sid") String workspaceSid, @JsonProperty(value="channel_optimized_routing") Boolean channelOptimizedRouting, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.sid = sid;
        this.uniqueName = uniqueName;
        this.workspaceSid = workspaceSid;
        this.channelOptimizedRouting = channelOptimizedRouting;
        this.url = url;
        this.links = links;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public final Boolean getChannelOptimizedRouting() {
        return this.channelOptimizedRouting;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskChannel other = (TaskChannel)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.sid, other.sid) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.workspaceSid, other.workspaceSid) && Objects.equals(this.channelOptimizedRouting, other.channelOptimizedRouting) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.dateCreated, this.dateUpdated, this.friendlyName, this.sid, this.uniqueName, this.workspaceSid, this.channelOptimizedRouting, this.url, this.links);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("friendlyName", this.friendlyName).add("sid", this.sid).add("uniqueName", this.uniqueName).add("workspaceSid", this.workspaceSid).add("channelOptimizedRouting", this.channelOptimizedRouting).add("url", this.url).add("links", this.links).toString();
    }
}

