/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trunking.v1.trunk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.http.HttpMethod;
import com.twilio.rest.trunking.v1.trunk.TerminatingSipDomainCreator;
import com.twilio.rest.trunking.v1.trunk.TerminatingSipDomainDeleter;
import com.twilio.rest.trunking.v1.trunk.TerminatingSipDomainFetcher;
import com.twilio.rest.trunking.v1.trunk.TerminatingSipDomainReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TerminatingSipDomain
extends Resource {
    private static final long serialVersionUID = 241276336890927L;
    private final String accountSid;
    private final String apiVersion;
    private final String authType;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String domainName;
    private final String friendlyName;
    private final String sid;
    private final URI url;
    private final HttpMethod voiceFallbackMethod;
    private final URI voiceFallbackUrl;
    private final HttpMethod voiceMethod;
    private final HttpMethod voiceStatusCallbackMethod;
    private final URI voiceStatusCallbackUrl;
    private final URI voiceUrl;
    private final Boolean sipRegistration;
    private final String trunkSid;
    private final Map<String, String> links;

    public static TerminatingSipDomainFetcher fetcher(String pathTrunkSid, String pathSid) {
        return new TerminatingSipDomainFetcher(pathTrunkSid, pathSid);
    }

    public static TerminatingSipDomainDeleter deleter(String pathTrunkSid, String pathSid) {
        return new TerminatingSipDomainDeleter(pathTrunkSid, pathSid);
    }

    public static TerminatingSipDomainCreator creator(String pathTrunkSid, String sipDomainSid) {
        return new TerminatingSipDomainCreator(pathTrunkSid, sipDomainSid);
    }

    public static TerminatingSipDomainReader reader(String pathTrunkSid) {
        return new TerminatingSipDomainReader(pathTrunkSid);
    }

    public static TerminatingSipDomain fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, TerminatingSipDomain.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static TerminatingSipDomain fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, TerminatingSipDomain.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private TerminatingSipDomain(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="api_version") String apiVersion, @JsonProperty(value="auth_type") String authType, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="domain_name") String domainName, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="sid") String sid, @JsonProperty(value="url") URI url, @JsonProperty(value="voice_fallback_method") HttpMethod voiceFallbackMethod, @JsonProperty(value="voice_fallback_url") URI voiceFallbackUrl, @JsonProperty(value="voice_method") HttpMethod voiceMethod, @JsonProperty(value="voice_status_callback_method") HttpMethod voiceStatusCallbackMethod, @JsonProperty(value="voice_status_callback_url") URI voiceStatusCallbackUrl, @JsonProperty(value="voice_url") URI voiceUrl, @JsonProperty(value="sip_registration") Boolean sipRegistration, @JsonProperty(value="trunk_sid") String trunkSid, @JsonProperty(value="links") Map<String, String> links) {
        this.accountSid = accountSid;
        this.apiVersion = apiVersion;
        this.authType = authType;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.domainName = domainName;
        this.friendlyName = friendlyName;
        this.sid = sid;
        this.url = url;
        this.voiceFallbackMethod = voiceFallbackMethod;
        this.voiceFallbackUrl = voiceFallbackUrl;
        this.voiceMethod = voiceMethod;
        this.voiceStatusCallbackMethod = voiceStatusCallbackMethod;
        this.voiceStatusCallbackUrl = voiceStatusCallbackUrl;
        this.voiceUrl = voiceUrl;
        this.sipRegistration = sipRegistration;
        this.trunkSid = trunkSid;
        this.links = links;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getApiVersion() {
        return this.apiVersion;
    }

    public final String getAuthType() {
        return this.authType;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getDomainName() {
        return this.domainName;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getSid() {
        return this.sid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final HttpMethod getVoiceFallbackMethod() {
        return this.voiceFallbackMethod;
    }

    public final URI getVoiceFallbackUrl() {
        return this.voiceFallbackUrl;
    }

    public final HttpMethod getVoiceMethod() {
        return this.voiceMethod;
    }

    public final HttpMethod getVoiceStatusCallbackMethod() {
        return this.voiceStatusCallbackMethod;
    }

    public final URI getVoiceStatusCallbackUrl() {
        return this.voiceStatusCallbackUrl;
    }

    public final URI getVoiceUrl() {
        return this.voiceUrl;
    }

    public final Boolean getSipRegistration() {
        return this.sipRegistration;
    }

    public final String getTrunkSid() {
        return this.trunkSid;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TerminatingSipDomain other = (TerminatingSipDomain)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.apiVersion, other.apiVersion) && Objects.equals(this.authType, other.authType) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.domainName, other.domainName) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.sid, other.sid) && Objects.equals(this.url, other.url) && Objects.equals((Object)this.voiceFallbackMethod, (Object)other.voiceFallbackMethod) && Objects.equals(this.voiceFallbackUrl, other.voiceFallbackUrl) && Objects.equals((Object)this.voiceMethod, (Object)other.voiceMethod) && Objects.equals((Object)this.voiceStatusCallbackMethod, (Object)other.voiceStatusCallbackMethod) && Objects.equals(this.voiceStatusCallbackUrl, other.voiceStatusCallbackUrl) && Objects.equals(this.voiceUrl, other.voiceUrl) && Objects.equals(this.sipRegistration, other.sipRegistration) && Objects.equals(this.trunkSid, other.trunkSid) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.apiVersion, this.authType, this.dateCreated, this.dateUpdated, this.domainName, this.friendlyName, this.sid, this.url, this.voiceFallbackMethod, this.voiceFallbackUrl, this.voiceMethod, this.voiceStatusCallbackMethod, this.voiceStatusCallbackUrl, this.voiceUrl, this.sipRegistration, this.trunkSid, this.links});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("apiVersion", this.apiVersion).add("authType", this.authType).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("domainName", this.domainName).add("friendlyName", this.friendlyName).add("sid", this.sid).add("url", this.url).add("voiceFallbackMethod", (Object)this.voiceFallbackMethod).add("voiceFallbackUrl", this.voiceFallbackUrl).add("voiceMethod", (Object)this.voiceMethod).add("voiceStatusCallbackMethod", (Object)this.voiceStatusCallbackMethod).add("voiceStatusCallbackUrl", this.voiceStatusCallbackUrl).add("voiceUrl", this.voiceUrl).add("sipRegistration", this.sipRegistration).add("trunkSid", this.trunkSid).add("links", this.links).toString();
    }
}

