/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trunking.v1.trunk;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.trunking.v1.trunk.TerminatingSipDomain;

public class TerminatingSipDomainCreator
extends Creator<TerminatingSipDomain> {
    private final String pathTrunkSid;
    private final String sipDomainSid;

    public TerminatingSipDomainCreator(String pathTrunkSid, String sipDomainSid) {
        this.pathTrunkSid = pathTrunkSid;
        this.sipDomainSid = sipDomainSid;
    }

    @Override
    public TerminatingSipDomain create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.TRUNKING.toString(), "/v1/Trunks/" + this.pathTrunkSid + "/TerminatingSipDomains", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("TerminatingSipDomain creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return TerminatingSipDomain.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.sipDomainSid != null) {
            request.addPostParam("SipDomainSid", this.sipDomainSid);
        }
    }
}

