/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.Service;

public class ServiceCreator
extends Creator<Service> {
    private final String friendlyName;
    private Integer codeLength;
    private Boolean lookupEnabled;
    private Boolean skipSmsToLandlines;
    private Boolean dtmfInputRequired;
    private String ttsName;
    private Boolean psd2Enabled;

    public ServiceCreator(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public ServiceCreator setCodeLength(Integer codeLength) {
        this.codeLength = codeLength;
        return this;
    }

    public ServiceCreator setLookupEnabled(Boolean lookupEnabled) {
        this.lookupEnabled = lookupEnabled;
        return this;
    }

    public ServiceCreator setSkipSmsToLandlines(Boolean skipSmsToLandlines) {
        this.skipSmsToLandlines = skipSmsToLandlines;
        return this;
    }

    public ServiceCreator setDtmfInputRequired(Boolean dtmfInputRequired) {
        this.dtmfInputRequired = dtmfInputRequired;
        return this;
    }

    public ServiceCreator setTtsName(String ttsName) {
        this.ttsName = ttsName;
        return this;
    }

    public ServiceCreator setPsd2Enabled(Boolean psd2Enabled) {
        this.psd2Enabled = psd2Enabled;
        return this;
    }

    @Override
    public Service create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.VERIFY.toString(), "/v2/Services", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Service creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Service.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.codeLength != null) {
            request.addPostParam("CodeLength", this.codeLength.toString());
        }
        if (this.lookupEnabled != null) {
            request.addPostParam("LookupEnabled", this.lookupEnabled.toString());
        }
        if (this.skipSmsToLandlines != null) {
            request.addPostParam("SkipSmsToLandlines", this.skipSmsToLandlines.toString());
        }
        if (this.dtmfInputRequired != null) {
            request.addPostParam("DtmfInputRequired", this.dtmfInputRequired.toString());
        }
        if (this.ttsName != null) {
            request.addPostParam("TtsName", this.ttsName);
        }
        if (this.psd2Enabled != null) {
            request.addPostParam("Psd2Enabled", this.psd2Enabled.toString());
        }
    }
}

