/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.verify.v2.service.VerificationCreator;
import com.twilio.rest.verify.v2.service.VerificationFetcher;
import com.twilio.rest.verify.v2.service.VerificationUpdater;
import com.twilio.type.PhoneNumber;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Verification
extends Resource {
    private static final long serialVersionUID = 203139503984797L;
    private final String sid;
    private final String serviceSid;
    private final String accountSid;
    private final PhoneNumber to;
    private final Channel channel;
    private final String status;
    private final Boolean valid;
    private final Map<String, Object> lookup;
    private final String amount;
    private final String payee;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;

    public static VerificationCreator creator(String pathServiceSid, String to, String channel) {
        return new VerificationCreator(pathServiceSid, to, channel);
    }

    public static VerificationUpdater updater(String pathServiceSid, String pathSid, Status status) {
        return new VerificationUpdater(pathServiceSid, pathSid, status);
    }

    public static VerificationFetcher fetcher(String pathServiceSid, String pathSid) {
        return new VerificationFetcher(pathServiceSid, pathSid);
    }

    public static Verification fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Verification.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Verification fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Verification.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Verification(@JsonProperty(value="sid") String sid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="to") PhoneNumber to, @JsonProperty(value="channel") Channel channel, @JsonProperty(value="status") String status, @JsonProperty(value="valid") Boolean valid, @JsonProperty(value="lookup") Map<String, Object> lookup, @JsonProperty(value="amount") String amount, @JsonProperty(value="payee") String payee, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.serviceSid = serviceSid;
        this.accountSid = accountSid;
        this.to = to;
        this.channel = channel;
        this.status = status;
        this.valid = valid;
        this.lookup = lookup;
        this.amount = amount;
        this.payee = payee;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final PhoneNumber getTo() {
        return this.to;
    }

    public final Channel getChannel() {
        return this.channel;
    }

    public final String getStatus() {
        return this.status;
    }

    public final Boolean getValid() {
        return this.valid;
    }

    public final Map<String, Object> getLookup() {
        return this.lookup;
    }

    public final String getAmount() {
        return this.amount;
    }

    public final String getPayee() {
        return this.payee;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Verification other = (Verification)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.to, other.to) && Objects.equals((Object)this.channel, (Object)other.channel) && Objects.equals(this.status, other.status) && Objects.equals(this.valid, other.valid) && Objects.equals(this.lookup, other.lookup) && Objects.equals(this.amount, other.amount) && Objects.equals(this.payee, other.payee) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.serviceSid, this.accountSid, this.to, this.channel, this.status, this.valid, this.lookup, this.amount, this.payee, this.dateCreated, this.dateUpdated, this.url});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("serviceSid", this.serviceSid).add("accountSid", this.accountSid).add("to", this.to).add("channel", (Object)this.channel).add("status", this.status).add("valid", this.valid).add("lookup", this.lookup).add("amount", this.amount).add("payee", this.payee).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("url", this.url).toString();
    }

    public static enum Status {
        CANCELED("canceled"),
        APPROVED("approved");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }

    public static enum Channel {
        SMS("sms"),
        CALL("call");

        private final String value;

        private Channel(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Channel forValue(String value) {
            return (Channel)Promoter.enumFromString((String)value, (Enum[])Channel.values());
        }
    }
}

