/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.verify.v2.service.VerificationCheckCreator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class VerificationCheck
extends Resource {
    private static final long serialVersionUID = 185560198235176L;
    private final String sid;
    private final String serviceSid;
    private final String accountSid;
    private final String to;
    private final Channel channel;
    private final String status;
    private final Boolean valid;
    private final String amount;
    private final String payee;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;

    public static VerificationCheckCreator creator(String pathServiceSid, String code) {
        return new VerificationCheckCreator(pathServiceSid, code);
    }

    public static VerificationCheck fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, VerificationCheck.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static VerificationCheck fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, VerificationCheck.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private VerificationCheck(@JsonProperty(value="sid") String sid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="to") String to, @JsonProperty(value="channel") Channel channel, @JsonProperty(value="status") String status, @JsonProperty(value="valid") Boolean valid, @JsonProperty(value="amount") String amount, @JsonProperty(value="payee") String payee, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated) {
        this.sid = sid;
        this.serviceSid = serviceSid;
        this.accountSid = accountSid;
        this.to = to;
        this.channel = channel;
        this.status = status;
        this.valid = valid;
        this.amount = amount;
        this.payee = payee;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getTo() {
        return this.to;
    }

    public final Channel getChannel() {
        return this.channel;
    }

    public final String getStatus() {
        return this.status;
    }

    public final Boolean getValid() {
        return this.valid;
    }

    public final String getAmount() {
        return this.amount;
    }

    public final String getPayee() {
        return this.payee;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerificationCheck other = (VerificationCheck)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.to, other.to) && Objects.equals((Object)this.channel, (Object)other.channel) && Objects.equals(this.status, other.status) && Objects.equals(this.valid, other.valid) && Objects.equals(this.amount, other.amount) && Objects.equals(this.payee, other.payee) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.serviceSid, this.accountSid, this.to, this.channel, this.status, this.valid, this.amount, this.payee, this.dateCreated, this.dateUpdated});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("serviceSid", this.serviceSid).add("accountSid", this.accountSid).add("to", this.to).add("channel", (Object)this.channel).add("status", this.status).add("valid", this.valid).add("amount", this.amount).add("payee", this.payee).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).toString();
    }

    public static enum Channel {
        SMS("sms"),
        CALL("call");

        private final String value;

        private Channel(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Channel forValue(String value) {
            return (Channel)Promoter.enumFromString((String)value, (Enum[])Channel.values());
        }
    }
}

