/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service.ratelimit;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.service.ratelimit.Bucket;

public class BucketReader
extends Reader<Bucket> {
    private final String pathServiceSid;
    private final String pathRateLimitSid;

    public BucketReader(String pathServiceSid, String pathRateLimitSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathRateLimitSid = pathRateLimitSid;
    }

    @Override
    public ResourceSet<Bucket> read(TwilioRestClient client) {
        return new ResourceSet<Bucket>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Bucket> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.VERIFY.toString(), "/v2/Services/" + this.pathServiceSid + "/RateLimits/" + this.pathRateLimitSid + "/Buckets", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Bucket> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Bucket> nextPage(Page<Bucket> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.VERIFY.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Bucket> previousPage(Page<Bucket> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.VERIFY.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Bucket> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Bucket read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("buckets", response.getContent(), Bucket.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

